package com.lowdragmc.lowdraglib.gui.graphprocessor.nodes.minecraft.entity;

import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.trigger.LinearTriggerNode;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

@LDLRegister(name = "spawn entity", group = "graph_processor.node.minecraft.entity")
public class SpawnEntityNode extends LinearTriggerNode {
    @InputPort
    public Level level;
    @InputPort
    public Vector3f xyz;
    @InputPort(name = "entity type")
    public EntityType entityType;
    @InputPort
    public int count;
    @InputPort
    public CompoundTag tag;

    @Override
    public void process() {
        if (level != null && xyz != null && entityType != null) {
            for (int i = 0; i < count; i++) {
                var entity = entityType.m_20615_(level);
                if (entity == null) {
                    return;
                }
                if (tag != null) {
                    entity.m_20258_(tag);
                }
                entity.m_6034_(xyz.x, xyz.y, xyz.z);
                level.m_7967_(entity);
            }
        }
    }
}
