package com.lowdragmc.lowdraglib.gui.modular;


import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.factory.HeldItemUIFactory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public interface IUIHolder {
    IUIHolder EMPTY = new IUIHolder() {
        @Override
        public ModularUI createUI(Player entityPlayer) {
            return null;
        }

        @Override
        public boolean isInvalid() {
            return false;
        }

        @Override
        public boolean isRemote() {
            return true;
        }

        @Override
        public void markAsDirty() {

        }
    };

    interface BlockEntityUI extends IUIHolder {
        default net.minecraft.world.level.block.entity.BlockEntity self() {
            return (net.minecraft.world.level.block.entity.BlockEntity) this;
        }

        @Override
        default boolean isInvalid() {
            return self().m_58901_();
        }

        @Override
        default boolean isRemote() {
            var level = self().m_58904_();
            return level == null ? LDLib.isRemote() : level.f_46443_;
        }

        @Override
        default void markAsDirty() {
            self().m_6596_();
        }
    }

    interface ItemUI {
        ModularUI createUI(Player entityPlayer, HeldItemUIFactory.HeldItemHolder holder);
    }

    ModularUI createUI(Player entityPlayer);

    boolean isInvalid();

    boolean isRemote();

    void markAsDirty();

}
