package com.lowdragmc.lowdraglib.gui.modular;

import com.lowdragmc.lowdraglib.core.mixins.accessor.AbstractContainerMenuAccessor;
import com.lowdragmc.lowdraglib.gui.util.PerTickIntCounter;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.networking.LDLNetworking;
import com.lowdragmc.lowdraglib.networking.c2s.CPacketUIClientAction;
import com.lowdragmc.lowdraglib.networking.s2c.SPacketUIWidgetUpdate;
import io.netty.buffer.Unpooled;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.*;
import net.minecraft.world.item.ItemStack;

import javax.annotation.Nonnull;
import java.util.Comparator;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class ModularUIContainer extends AbstractContainerMenu implements WidgetUIAccess {
    public static final MenuType<ModularUIContainer> MENUTYPE = new MenuType<>((i, inventory) -> new ModularUIContainer(i), FeatureFlags.f_244332_);

    private final ModularUI modularUI;

    public ModularUIContainer(ModularUI modularUI, int windowID) {
        super(MENUTYPE, windowID);
        this.modularUI = modularUI;
        this.modularUI.setModularUIContainer(this);
        modularUI.mainGroup.setUiAccess(this);
    }

    private ModularUIContainer(int windowID) {
        super(null, windowID);
        this.modularUI = null;
    }

    //WARNING! WIDGET CHANGES SHOULD BE *STRICTLY* SYNCHRONIZED BETWEEN SERVER AND CLIENT,
    //OTHERWISE ID MISMATCH CAN HAPPEN BETWEEN ASSIGNED SLOTS!
    @Nonnull
    public Slot m_38897_(@Nonnull Slot slotHandle) {
        var emptySlotIndex = f_38839_.stream()
                .filter(it -> it instanceof EmptySlotPlaceholder)
                .mapToInt(slot -> slot.f_40219_).findFirst();
        if (emptySlotIndex.isPresent()) {
            slotHandle.f_40219_ = emptySlotIndex.getAsInt();
            this.f_38839_.set(slotHandle.f_40219_, slotHandle);
            ((AbstractContainerMenuAccessor)this).getLastSlots().set(slotHandle.f_40219_, ItemStack.f_41583_);
            ((AbstractContainerMenuAccessor)this).getRemoteSlots().set(slotHandle.f_40219_, ItemStack.f_41583_);
        } else {
            slotHandle.f_40219_ = this.f_38839_.size();
            this.f_38839_.add(slotHandle);
            ((AbstractContainerMenuAccessor)this).getLastSlots().add(ItemStack.f_41583_);
            ((AbstractContainerMenuAccessor)this).getRemoteSlots().add(ItemStack.f_41583_);
        }
        return slotHandle;
    }

    //WARNING! WIDGET CHANGES SHOULD BE *STRICTLY* SYNCHRONIZED BETWEEN SERVER AND CLIENT,
    //OTHERWISE ID MISMATCH CAN HAPPEN BETWEEN ASSIGNED SLOTS!
    public void removeSlot(Slot slotHandle) {
        //replace removed slot with empty placeholder to avoid list index shift
        EmptySlotPlaceholder emptySlotPlaceholder = new EmptySlotPlaceholder();
        emptySlotPlaceholder.f_40219_ = slotHandle.f_40219_;
        this.f_38839_.set(slotHandle.f_40219_, emptySlotPlaceholder);
        ((AbstractContainerMenuAccessor)this).getLastSlots().set(slotHandle.f_40219_, ItemStack.f_41583_);
        ((AbstractContainerMenuAccessor)this).getRemoteSlots().set(slotHandle.f_40219_, ItemStack.f_41583_);
    }

    public ModularUI getModularUI() {
        return modularUI;
    }

    @Override
    public void m_6877_(@Nonnull Player playerIn) {
        super.m_6877_(playerIn);
        modularUI.triggerCloseListeners();
    }

    @Override
    public void m_38893_(@Nonnull ContainerListener pListener) {
        super.m_38893_(pListener);
        modularUI.mainGroup.detectAndSendChanges();
    }

    @Override
    public void m_38946_() {
        super.m_38946_();
        if (modularUI.holder.isInvalid() && modularUI.entityPlayer instanceof ServerPlayer serverPlayer) {
            serverPlayer.m_6915_();
        }
        modularUI.mainGroup.detectAndSendChanges();
        modularUI.addTick();
    }

    @Override
    public void m_150399_(int slotId, int dragType, @Nonnull ClickType clickTypeIn, @Nonnull Player player) {
        if (slotId >= 0 && slotId < f_38839_.size()) {
            Slot slot = m_38853_(slotId);
            ItemStack result = modularUI.getSlotMap().get(slot).slotClick(dragType, clickTypeIn, player);
            if (result == null) {
//                return super.clicked(slotId, dragType, clickTypeIn, player);
                super.m_150399_(slotId, dragType, clickTypeIn, player);
            }
//            return result;
        }
        if (slotId == -999) {
            super.m_150399_(slotId, dragType, clickTypeIn, player);
        }
//        return ItemStack.EMPTY;
    }

    private final PerTickIntCounter transferredPerTick = new PerTickIntCounter(0);

    private List<SlotWidget> getShiftClickSlots(ItemStack itemStack, boolean fromContainer) {
        return modularUI.getSlotMap().values().stream()
                .filter(it -> it.canMergeSlot(itemStack))
                .filter(it -> it.isPlayerContainer == fromContainer)
                .sorted(Comparator.comparing(s -> (fromContainer ? -1 : 1) * s.getHandler().index))
                .collect(Collectors.toList());
    }

    @Override
    public boolean attemptMergeStack(ItemStack itemStack, boolean fromContainer, boolean simulate) {
        List<Slot> slots = getShiftClickSlots(itemStack, fromContainer).stream()
                .map(SlotWidget::getHandler)
                .collect(Collectors.toList());
        return mergeItemStack(itemStack, slots, simulate);
    }

    public static boolean mergeItemStack(ItemStack itemStack, List<Slot> slots, boolean simulate) {
        if (itemStack.m_41619_())
            return false; //if we are merging empty stack, return

        boolean merged = false;
        //iterate non-empty slots first
        //to try to insert stack into them
        for (Slot slot : slots) {
            if (!slot.m_5857_(itemStack))
                continue; //if itemstack cannot be placed into that slot, continue
            ItemStack stackInSlot = slot.m_7993_();
            if (!ItemStack.m_41656_(itemStack, stackInSlot) || !ItemStack.m_150942_(itemStack, stackInSlot))
                continue; //if itemstacks don't match, continue
            int slotMaxStackSize = Math.min(stackInSlot.m_41741_(), slot.m_5866_(stackInSlot));
            int amountToInsert = Math.min(itemStack.m_41613_(), slotMaxStackSize - stackInSlot.m_41613_());
            if (amountToInsert == 0)
                continue; //if we can't insert anything, continue
            //shrink our stack, grow slot's stack and mark slot as changed
            if (!simulate) {
                stackInSlot.m_41769_(amountToInsert);
            }
            itemStack.m_41774_(amountToInsert);
            slot.m_6654_();
            merged = true;
            if (itemStack.m_41619_())
                return true; //if we inserted all items, return
        }

        //then try to insert itemstack into empty slots
        //breaking it into pieces if needed
        for (Slot slot : slots) {
            if (!slot.m_5857_(itemStack))
                continue; //if itemstack cannot be placed into that slot, continue
            if (slot.m_6657_())
                continue; //if slot contains something, continue
            int amountToInsert = Math.min(itemStack.m_41613_(), slot.m_5866_(itemStack));
            if (amountToInsert == 0)
                continue; //if we can't insert anything, continue
            //split our stack and put result in slot
            ItemStack stackInSlot = itemStack.m_41620_(amountToInsert);
            if (!simulate) {
                slot.m_5852_(stackInSlot);
            }
            merged = true;
            if (itemStack.m_41619_())
                return true; //if we inserted all items, return
        }
        return merged;
    }


    @Nonnull
    @Override
    public ItemStack m_7648_(@Nonnull Player player, int index) {
        Slot slot = f_38839_.get(index);
        if (!slot.m_8010_(player)) {
            return ItemStack.f_41583_;
        }
        if (!slot.m_6657_()) {
            //return empty if we can't transfer it
            return ItemStack.f_41583_;
        }
        ItemStack stackInSlot = slot.m_7993_();
//        ItemStack stackToMerge = modularUI.getSlotMap().get(slot).onItemTake(player, stackInSlot.copy(), true);
        ItemStack stackToMerge = stackInSlot.m_41777_();
        boolean fromContainer = !modularUI.getSlotMap().get(slot).isPlayerContainer;
        if (!attemptMergeStack(stackToMerge, fromContainer, true)) {
            return ItemStack.f_41583_;
        }
        int itemsMerged;
        if (stackToMerge.m_41619_() || modularUI.getSlotMap().get(slot).canMergeSlot(stackToMerge)) {
            itemsMerged = stackInSlot.m_41613_() - stackToMerge.m_41613_();
        } else {
            //if we can't have partial stack merge, we have to use all the stack
            itemsMerged = stackInSlot.m_41613_();
        }
        int itemsToExtract = itemsMerged;
        itemsMerged += transferredPerTick.get(player.m_9236_());
        if (itemsMerged > stackInSlot.m_41741_()) {
            //we can merge at most one stack at a time
            return ItemStack.f_41583_;
        }
        transferredPerTick.increment(player.m_9236_(), itemsToExtract);
        //otherwise, perform extraction and merge
        ItemStack extractedStack = stackInSlot.m_41620_(itemsToExtract);
        if (stackInSlot.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
//        extractedStack = modularUI.getSlotMap().get(slot).onItemTake(player, extractedStack, false);
        ItemStack resultStack = extractedStack.m_41777_();
        if (!attemptMergeStack(extractedStack, fromContainer, false)) {
            resultStack = ItemStack.f_41583_;
        }
        if (!extractedStack.m_41619_()) {
            player.m_7197_(extractedStack, false, false);
            resultStack = ItemStack.f_41583_;
        }
        return resultStack;
    }

    @Override
    public boolean m_5882_(@Nonnull ItemStack stack, @Nonnull Slot slotIn) {
        return modularUI.getSlotMap().get(slotIn).canMergeSlot(stack);
    }

    @Override
    public boolean m_6875_(@Nonnull Player playerIn) {
        return true;
    }

    @Override
    public void writeClientAction(Widget widget, int updateId, Consumer<FriendlyByteBuf> payloadWriter) {
        FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
        packetBuffer.m_130130_(updateId);
        payloadWriter.accept(packetBuffer);
        if (modularUI.entityPlayer instanceof AbstractClientPlayer) {
            LDLNetworking.NETWORK.sendToServer(new CPacketUIClientAction(f_38840_, packetBuffer));
        }
    }

    @Override
    public void writeUpdateInfo(Widget widget, int updateId, Consumer<FriendlyByteBuf> payloadWriter) {
        FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
        packetBuffer.m_130130_(updateId);
        payloadWriter.accept(packetBuffer);
        if (modularUI.entityPlayer instanceof ServerPlayer) {
            SPacketUIWidgetUpdate widgetUpdate = new SPacketUIWidgetUpdate(f_38840_, packetBuffer);
            LDLNetworking.NETWORK.sendToPlayer(widgetUpdate, (ServerPlayer) modularUI.entityPlayer);
        }
    }

    public void handleClientAction(CPacketUIClientAction packet) {
        if (packet.windowId == f_38840_) {
            int updateId = packet.updateData.m_130242_();
            modularUI.mainGroup.handleClientAction(updateId, packet.updateData);
        }
    }

    private static class EmptySlotPlaceholder extends Slot {

        private static final Container EMPTY_INVENTORY = new SimpleContainer(0);

        public EmptySlotPlaceholder() {
            super(EMPTY_INVENTORY, 0, -100000, -100000);
        }

        @Nonnull
        @Override
        public ItemStack m_7993_() {
            return ItemStack.f_41583_;
        }
        
        
        @Override
        public void m_5852_(@Nonnull ItemStack stack) {
        }

        @Override
        public boolean m_5857_(@Nonnull ItemStack stack) {
            return false;
        }

        @Override
        public boolean m_8010_(@Nonnull Player playerIn) {
            return false;
        }

        @Override
        public boolean m_6659_() {
            return false;
        }
    }
}
