package com.lowdragmc.lowdraglib.gui.modular;

import Z;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.core.mixins.accessor.AbstractContainerScreenAccessor;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.networking.s2c.SPacketUIWidgetUpdate;
import com.lowdragmc.lowdraglib.side.ForgeEventHooks;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.screen.EmiScreenManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@Environment(EnvType.CLIENT)
public class ModularUIGuiContainer extends AbstractContainerScreen<ModularUIContainer> {

    public final ModularUI modularUI;
    public Widget lastFocus;
    public boolean focused;
    public int dragSplittingLimit;
    public int dragSplittingButton;
    // hover tips
    @Nullable
    public List<Component> tooltipTexts;
    @Nullable
    public TooltipComponent tooltipComponent;
    @Nullable
    public Font tooltipFont;
    @Nullable
    public ItemStack tooltipStack = ItemStack.f_41583_;
    // drag element
    protected Tuple<Object, IGuiTexture> draggingElement;
    protected int pressedButton = -1;

    public ModularUIGuiContainer(ModularUI modularUI, int windowId) {
        super(new ModularUIContainer(modularUI, windowId), modularUI.entityPlayer.m_150109_(), Component.m_130674_("modularUI"));
        this.modularUI = modularUI;
        modularUI.setModularUIGui(this);
    }

    public void setHoverTooltip(List<Component> tooltipTexts, ItemStack tooltipStack, @Nullable Font tooltipFont, @Nullable TooltipComponent tooltipComponent) {
        this.tooltipTexts = tooltipTexts;
        this.tooltipStack = tooltipStack;
        this.tooltipFont = tooltipFont;
        this.tooltipComponent = tooltipComponent;
    }

    public boolean setDraggingElement(Object element, IGuiTexture renderer) {
        if (draggingElement != null) return false;
        draggingElement = new Tuple<>(element, renderer);
        return true;
    }

    @Nullable
    public Object getDraggingElement() {
        if (draggingElement == null) return null;
        return draggingElement.m_14418_();
    }

    @Override
    public void m_7856_() {
        this.f_97726_ = modularUI.getWidth();
        this.f_97727_ = modularUI.getHeight();
        super.m_7856_();
        this.modularUI.updateScreenSize(f_96543_, f_96544_);
    }

    @Override
    protected void m_7286_(GuiGraphics graphics, float delta, int mouseX, int mouseY) {

    }

    @Override
    public void m_7861_() {
        super.m_7861_();
    }

    @Override
    public void m_181908_() {
        super.m_181908_();
        if (modularUI.holder.isInvalid() && modularUI.entityPlayer instanceof ServerPlayer serverPlayer) {
            serverPlayer.m_6915_();
        }
        modularUI.mainGroup.updateScreen();
        modularUI.addTick();
    }

    public void handleWidgetUpdate(SPacketUIWidgetUpdate packet) {
        if (packet.windowId == m_6262_().f_38840_) {
            int updateId = packet.updateData.m_130242_();
            modularUI.mainGroup.readUpdateInfo(updateId, packet.updateData);
        }
    }

    @Override
    public void m_88315_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.f_97734_ = null;
        
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask(false);

        tooltipTexts = null;
        tooltipComponent = null;

        this.m_280273_(graphics);
        if (Platform.isForge()) ForgeEventHooks.postBackgroundRenderedEvent(this, graphics);

        modularUI.mainGroup.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        if (Platform.isForge()) ForgeEventHooks.postRenderBackgroundEvent(this, graphics, mouseX, mouseY);

        if (LDLib.isEmiLoaded()) {
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask(true);
            RenderSystem.setShader(GameRenderer::m_172817_);
            EmiScreenManager.render(EmiDrawContext.wrap(graphics), mouseX, mouseY, partialTicks);
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask(false);
        }

        modularUI.mainGroup.drawInForeground(graphics, mouseX, mouseY, partialTicks);

        if (draggingElement != null) {
            draggingElement.m_14419_().draw(graphics, mouseX, mouseY, mouseX - 20, mouseY - 20, 40, 40);
        }

        graphics.m_280091_().m_109911_();

        RenderSystem.enableDepthTest();
        RenderSystem.depthMask(true);

        PoseStack posestack = graphics.m_280168_();
        posestack.m_85836_();
        posestack.m_252880_(f_97735_, f_97736_, 232);

        if (Platform.isForge()) ForgeEventHooks.postRenderForegroundEvent(this, graphics, mouseX, mouseY);

        renderItemStackOnMouse(graphics, mouseX, mouseY);
        renderReturningItemStack(graphics);

        graphics.m_280091_().m_109911_();
        posestack.m_85849_();
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask(true);

        if (LDLib.isEmiLoaded()) {
            posestack.m_85836_();
            posestack.m_252880_(0, 0, 200);
            RenderSystem.setShader(GameRenderer::m_172817_);
            EmiScreenManager.drawForeground(EmiDrawContext.wrap(graphics), mouseX, mouseY, partialTicks);
            posestack.m_85849_();
        }

        if (draggingElement == null && tooltipTexts != null && !tooltipTexts.isEmpty()) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0, 0, 200);
            DrawerHelper.drawTooltip(graphics, mouseX, mouseY, tooltipTexts, tooltipStack, tooltipComponent, tooltipFont == null ? Minecraft.m_91087_().f_91062_ : tooltipFont);
            graphics.m_280168_().m_85849_();
        }
    }

    public void setHoveredSlot(Slot hoveredSlot) {
        // to make sure the widget won't trigger xei slot lookup
        if (modularUI.mainGroup.isClientSideWidget() && !modularUI.mainGroup.isAllowXEIIngredientOverMouse()) {
            return;
        }
        this.f_97734_ = hoveredSlot;
    }

    private void renderItemStackOnMouse(GuiGraphics graphics, int mouseX, int mouseY) {
        if (f_96541_ == null || f_96541_.f_91074_ == null) return;
        ItemStack draggedStack = ((AbstractContainerScreenAccessor)this).getDraggingItem();
        ItemStack itemstack = draggedStack.m_41619_() ? m_6262_().m_142621_() : draggedStack;
        if (!itemstack.m_41619_()) {
            int k2 = draggedStack.m_41619_() ? 8 : 16;
            String s = null;
            if (!draggedStack.m_41619_() && ((AbstractContainerScreenAccessor)this).isSplittingStack()) {
                itemstack = itemstack.m_41777_();
                itemstack.m_41764_((int) Math.ceil((float)itemstack.m_41613_() / 2.0F));
            } else if (this.f_97738_ && this.f_97737_.size() > 1) {
                itemstack = itemstack.m_41777_();
                itemstack.m_41764_(((AbstractContainerScreenAccessor)this).getQuickCraftingRemainder());
                if (itemstack.m_41619_()) {
                    s = ChatFormatting.YELLOW + "0";
                }
            }
            this.m_280211_(graphics, itemstack, mouseX - f_97735_ - 8, mouseY - f_97736_ - k2, s);
        }

    }

    public void m_280211_(GuiGraphics graphics, ItemStack stack, int x, int y, @Nullable String amountText) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(0.0f, 0.0f, 232.0f);
        graphics.m_280480_(stack, x, y);
        graphics.m_280302_(this.f_96547_, stack, x, y - (((AbstractContainerScreenAccessor)this).getDraggingItem().m_41619_() ? 0 : 8), amountText);
        graphics.m_280168_().m_85849_();
    }

    private void renderReturningItemStack(GuiGraphics graphics) {
        if (!((AbstractContainerScreenAccessor)this).getSnapbackItem().m_41619_()) {
            float f = (float)(Util.m_137550_() - ((AbstractContainerScreenAccessor)this).getSnapbackTime()) / 100.0F;
            if (f >= 1.0F) {
                f = 1.0F;
                ((AbstractContainerScreenAccessor)this).setSnapbackItem(ItemStack.f_41583_);
            }

            int l2 = ((AbstractContainerScreenAccessor)this).getSnapbackEnd().f_40220_ - ((AbstractContainerScreenAccessor)this).getSnapbackStartX();
            int i3 = ((AbstractContainerScreenAccessor)this).getSnapbackEnd().f_40221_ - ((AbstractContainerScreenAccessor)this).getSnapbackStartY();
            int l1 = ((AbstractContainerScreenAccessor)this).getSnapbackStartX() + (int)((float)l2 * f);
            int i2 = ((AbstractContainerScreenAccessor)this).getSnapbackStartY() + (int)((float)i3 * f);
            this.m_280211_(graphics, ((AbstractContainerScreenAccessor)this).getSnapbackItem(), l1, i2, null);
        }
    }

    public boolean switchFocus(@Nonnull Widget widget) {
        if (focused) return false;
        focused = true;
        if (lastFocus == widget) return false;
        Widget l = lastFocus;
        lastFocus = widget;
        if (l != null) l.setFocus(false);
        return true;
    }

    public Set<Slot> getQuickCraftSlots() {
        return this.f_97737_;
    }

    public boolean getQuickCrafting() {
        return this.f_97738_;
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int pButton) {
        pressedButton = pButton;
        focused = false;
        if (modularUI.mainGroup.mouseClicked(mouseX, mouseY, pButton)) return true;
        for (GuiEventListener guiEventListener : this.m_6702_()) {
            if (!guiEventListener.m_6375_(mouseX, mouseY, pButton)) continue;
            this.m_7522_(guiEventListener);
            if (pButton == 0) {
                this.m_7897_(true);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean m_7979_(double mouseX, double mouseY, int pButton, double pDragX, double pDragY) {
        focused = false;
        if (modularUI.mainGroup.mouseDragged(mouseX, mouseY, pButton, pDragX, pDragY)) return true;
        if (this.m_7222_() != null && this.m_7282_() && pButton == 0) {
            return this.m_7222_().m_7979_(mouseX, mouseY, pButton, pDragX, pDragY);
        }
        return false;
    }

    @Override
    public boolean m_6348_(double mouseX, double mouseY, int pButton) {
        pressedButton = -1;
        focused = false;
        var result = modularUI.mainGroup.mouseReleased(mouseX, mouseY, pButton);
        draggingElement = null;
        if (result) return true;
        this.m_7897_(false);
        return this.m_94729_(mouseX, mouseY).filter(guiEventListener -> guiEventListener.m_6348_(mouseX, mouseY, pButton)).isPresent();
    }

    @Override
    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        focused = false;
        if (modularUI.mainGroup.keyPressed(keyCode, scanCode, modifiers)) {
            return false;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean m_6050_(double mouseX, double mouseY, double wheelDelta) {
        focused = false;
        if (modularUI.mainGroup.mouseWheelMove(mouseX, mouseY, wheelDelta)) return true;
        return this.m_94729_(mouseX, mouseY).filter(element -> element.m_6050_(mouseX, mouseY, wheelDelta)).isPresent();
    }

    @Override
    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        focused = false;
        if (modularUI.mainGroup.keyReleased(keyCode, scanCode, modifiers)) return true;
        return this.m_7222_() != null && this.m_7222_().m_7920_(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean m_5534_(char codePoint, int modifiers) {
        focused = false;
        if (modularUI.mainGroup.charTyped(codePoint, modifiers)) return true;
        return this.m_7222_() != null && this.m_7222_().m_5534_(codePoint, modifiers);
    }

    @Override
    public void m_94757_(double mouseX, double mouseY) {
        focused = false;
        modularUI.mainGroup.mouseMoved(mouseX, mouseY);
    }

    public boolean isButtonPressed(int button) {
        return pressedButton == button;
    }

    public void superMouseClicked(double mouseX, double mouseY, int mouseButton) {
        try {
            super.m_6375_(mouseX, mouseY, mouseButton);
        } catch (Exception ignored) { }
    }

    public void superMouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public void superMouseReleased(double mouseX, double mouseY, int state) {
        super.m_6348_(mouseX, mouseY, state);
    }

    public boolean superKeyPressed(int keyCode, int scanCode, int modifiers) {
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean superMouseScrolled(double mouseX, double mouseY, double wheelDelta) {
        return super.m_6050_(mouseX, mouseY, wheelDelta);
    }

    public boolean superKeyReleased(int keyCode, int scanCode, int modifiers) {
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean superCharTyped(char codePoint, int modifiers) {
        return super.m_5534_(codePoint, modifiers);
    }

    public void superMouseMoved(double mouseX, double mouseY) {
        super.m_94757_(mouseX, mouseY);
    }


    public List<Rect2i> getGuiExtraAreas() {
        return modularUI.mainGroup.getGuiExtraAreas(modularUI.mainGroup.toRectangleBox(), new ArrayList<>());
    }
}
