package com.lowdragmc.lowdraglib.gui.texture;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector.Wrapper;
import com.lowdragmc.lowdraglib.gui.editor.runtime.PersistedParser;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import javax.annotation.Nullable;

import java.util.HashMap;
import java.util.function.Function;

import static com.mojang.blaze3d.vertex.DefaultVertexFormat.f_85817_;

public interface IGuiTexture extends IConfigurable {

    default IGuiTexture setColor(int color){
        return this;
    }

    default IGuiTexture rotate(float degree) {
        return this;
    }

    default IGuiTexture scale(float scale) {
        return this;
    }

    default IGuiTexture transform(int xOffset, int yOffset) {
        return this;
    }

    @Environment(EnvType.CLIENT)
    void draw(GuiGraphics graphics, int mouseX, int mouseY, float x, float y, int width, int height);

    @Environment(EnvType.CLIENT)
    default void updateTick() { }
    
    IGuiTexture EMPTY = new IGuiTexture() {
        @Environment(EnvType.CLIENT)
        @Override
        public void draw(GuiGraphics graphics, int mouseX, int mouseY, float x, float y, int width, int height) {

        }
    };

    IGuiTexture MISSING_TEXTURE = new IGuiTexture() {
        @Environment(EnvType.CLIENT)
        @Override
        public void draw(GuiGraphics graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
            Tesselator tessellator = Tesselator.m_85913_();
            BufferBuilder bufferbuilder = tessellator.m_85915_();
            RenderSystem.setShader(GameRenderer::m_172820_);
            RenderSystem.setShaderTexture(0, TextureManager.f_118466_);
            var matrix4f = graphics.m_280168_().m_85850_().m_252922_();
            bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, f_85817_);
            bufferbuilder.m_252986_(matrix4f, x, y + height, 0).m_7421_(0, 1).m_5752_();
            bufferbuilder.m_252986_(matrix4f, x + width, y + height, 0).m_7421_(1, 1).m_5752_();
            bufferbuilder.m_252986_(matrix4f, x + width, y, 0).m_7421_(1, 0).m_5752_();
            bufferbuilder.m_252986_(matrix4f, x, y, 0).m_7421_(0, 0).m_5752_();
            tessellator.m_85914_();
        }
    };

    @Environment(EnvType.CLIENT)
    default void drawSubArea(GuiGraphics graphics, float x, float y, float width, float height, float drawnU, float drawnV, float drawnWidth, float drawnHeight) {
        draw(graphics, 0, 0, x, y, (int) width, (int) height);
    }

    default IGuiTexture copy() {
        var tag = serializeWrapper(this);
        return tag == null ? this : deserializeWrapper(tag);
    }

    // ***************** EDITOR  ***************** //

    Function<String, AnnotationDetector.Wrapper<LDLRegister, IGuiTexture>> CACHE = Util.m_143827_(type -> {
        for (var wrapper : AnnotationDetector.REGISTER_TEXTURES) {
            if (wrapper.annotation().name().equals(type)) {
                return wrapper;
            }
        }
        return null;
    });

    default void createPreview(ConfiguratorGroup father) {
        father.addConfigurators(new WrapperConfigurator("ldlib.gui.editor.group.preview",
                new ImageWidget(0, 0, 100, 100, this)
                        .setBorder(2, ColorPattern.T_WHITE.color)));
    }

    @Override
    default void buildConfigurator(ConfiguratorGroup father) {
        createPreview(father);
        IConfigurable.super.buildConfigurator(father);
    }

    @Nullable
    static CompoundTag serializeWrapper(IGuiTexture texture) {
        if (texture.isLDLRegister()) {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("type", texture.name());
            CompoundTag data = new CompoundTag();
            PersistedParser.serializeNBT(data, texture.getClass(), texture);
            tag.m_128365_("data", data);
            return tag;
        }
        return null;
    }

    @NotNull
    static IGuiTexture deserializeWrapper(CompoundTag tag) {
        var type = tag.m_128461_("type");
        var data = tag.m_128469_("data");
        var wrapper = CACHE.apply(type);
        IGuiTexture value = wrapper == null ? IGuiTexture.EMPTY : wrapper.creator().get();
        PersistedParser.deserializeNBT(data, new HashMap<>(), value.getClass(), value);
        return value;
    }

    default void setUIResource(Resource<IGuiTexture> texturesResource) {

    }
}
