package com.lowdragmc.lowdraglib.gui.texture;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import lombok.Getter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

@LDLRegister(name = "item_stack_texture", group = "texture")
public class ItemStackTexture extends TransformTexture {
    @Configurable(name = "ldlib.gui.editor.name.items")
    public ItemStack[] items;
    private int index = 0;
    private int ticks = 0;
    @Configurable(name = "ldlib.gui.editor.name.color")
    @Getter
    private int color = -1;
    private long lastTick;

    public ItemStackTexture() {
        this(Items.f_42410_.m_5456_());
    }


    public ItemStackTexture(ItemStack... itemStacks) {
        this.items = itemStacks;
    }

    public ItemStackTexture(Item... items) {
        this.items = new ItemStack[items.length];
        for(int i = 0; i < items.length; i++) {
            this.items[i] = new ItemStack(items[i]);
        }
    }

    public ItemStackTexture setItems(ItemStack... itemStack) {
        this.items = itemStack;
        return this;
    }

    @Override
    public ItemStackTexture setColor(int color) {
        this.color = color;
        return this;
    }

    @Override
    @Environment(EnvType.CLIENT)
    public void updateTick() {
        if (Minecraft.m_91087_().f_91073_ != null) {
            long tick = Minecraft.m_91087_().f_91073_.m_46467_();
            if (tick == lastTick) return;
            lastTick = tick;
        }
        if(items.length > 1 && ++ticks % 20 == 0)
            if(++index == items.length)
                index = 0;
    }

    @Environment(EnvType.CLIENT)
    @Override
    protected void drawInternal(GuiGraphics graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
        if (items.length == 0) return;
        updateTick();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85841_(width / 16f, height / 16f, 1);
        graphics.m_280168_().m_252880_(x * 16 / width, y * 16 / height, -200);
        DrawerHelper.drawItemStack(graphics, items[index], 0, 0, color, null);
        graphics.m_280168_().m_85849_();
    }
}
