package com.lowdragmc.lowdraglib.gui.util;

import com.lowdragmc.lowdraglib.core.mixins.accessor.MouseHandlerAccessor;
import com.mojang.blaze3d.platform.InputConstants;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.network.FriendlyByteBuf;
import org.lwjgl.glfw.GLFW;

public class ClickData {
    public final int button;
    public final boolean isShiftClick;
    public final boolean isCtrlClick;
    public final boolean isRemote;

    private ClickData(int button, boolean isShiftClick, boolean isCtrlClick, boolean isRemote) {
        this.button = button;
        this.isShiftClick = isShiftClick;
        this.isCtrlClick = isCtrlClick;
        this.isRemote = isRemote;
    }

    @Environment(EnvType.CLIENT)
    public ClickData() {
        MouseHandler mouseHelper = Minecraft.m_91087_().f_91067_;
        long id = Minecraft.m_91087_().m_91268_().m_85439_();
        this.button = mouseHelper instanceof MouseHandlerAccessor accessor ? accessor.getActiveButton() : -1;
        this.isShiftClick = InputConstants.m_84830_(id, GLFW.GLFW_KEY_LEFT_SHIFT) || InputConstants.m_84830_(id, GLFW.GLFW_KEY_RIGHT_SHIFT);
        this.isCtrlClick = InputConstants.m_84830_(id, GLFW.GLFW_KEY_LEFT_CONTROL) || InputConstants.m_84830_(id, GLFW.GLFW_KEY_RIGHT_CONTROL);
        this.isRemote = true;
    }

    @Environment(EnvType.CLIENT)
    public void writeToBuf(FriendlyByteBuf buf) {
        buf.m_130130_(button);
        buf.writeBoolean(isShiftClick);
        buf.writeBoolean(isCtrlClick);
    }

    public static ClickData readFromBuf(FriendlyByteBuf buf) {
        int button = buf.m_130242_();
        boolean shiftClick = buf.readBoolean();
        boolean ctrlClick = buf.readBoolean();
        return new ClickData(button, shiftClick, ctrlClick, false);
    }
}
