package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.gui.texture.ColorBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.ColorRectTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class BlockSelectorWidget extends WidgetGroup {
    private Consumer<BlockState> onBlockStateUpdate;
    private Block block;
    private final IItemTransfer handler;
    private final TextFieldWidget blockField;
    private final Map<Property, Comparable> properties;

    public BlockSelectorWidget(int x, int y, int width, boolean isState) {
        super(x, y, width, 20);
        setClientSideWidget();
        properties = new HashMap<>();
        blockField = (TextFieldWidget) new TextFieldWidget(22, 0, width - (isState ?  46 : 26), 20, null, s -> {
            if (s != null && !s.isEmpty()) {
                Block block = BuiltInRegistries.f_256975_.m_7745_(new ResourceLocation(s));
                if (this.block != block) {
                    this.block = block;
                    onUpdate();
                }
            }
        }).setResourceLocationOnly().setHoverTooltips("ldlib.gui.tips.block_selector");

        addWidget(new PhantomSlotWidget(handler = new ItemStackTransfer(1), 0, 1, 1)
                .setClearSlotOnRightClick(true)
                .setChangeListener(() -> {
                    ItemStack stack = handler.getStackInSlot(0);
                    if (stack.isEmpty() || !(stack.getItem() instanceof BlockItem itemBlock)) {
                        var fluidTransfer = FluidTransferHelper.getFluidTransfer(handler, 0);
                        if (fluidTransfer != null) {
                            if (fluidTransfer.getTanks() > 0) {
                                var fluid = fluidTransfer.getFluidInTank(0).getFluid();
                                setBlock(fluid.defaultFluidState().createLegacyBlock());
                                onUpdate();
                                return;
                            }
                        }
                        if (block != null){
                            setBlock(null);
                            onUpdate();
                        }
                    } else {
                        setBlock(itemBlock.getBlock().defaultBlockState());
                        onUpdate();
                    }
                }).setBackgroundTexture(new ColorBorderTexture(1, -1)));
        addWidget(blockField);
        if (isState) {
            addWidget(new ButtonWidget(width - 21, 0, 20, 20, new ItemStackTexture(Items.f_41938_, Items.f_41870_, Items.f_41934_, Items.f_41936_, Items.f_41874_), cd -> {
                DraggableScrollableWidgetGroup group;
                new DialogWidget(getGui().mainGroup, isClientSideWidget)
                        .setOnClosed(this::onUpdate)
                        .addWidget(group = new DraggableScrollableWidgetGroup(0, 0, getGui().mainGroup.getSize().width, getGui().mainGroup.getSize().height)
                                .setYScrollBarWidth(4).setYBarStyle(null, new ColorRectTexture(-1))
                                .setXScrollBarHeight(4).setXBarStyle(null, new ColorRectTexture(-1))
                                .setBackground(new ColorRectTexture(0x8f222222)));
                int i = properties.size() - 1;
                for (Map.Entry<Property, Comparable> entry : properties.entrySet()) {
                    Property property = entry.getKey();
                    Comparable value = entry.getValue();
                    group.addWidget(new SelectorWidget(3, 3 + i * 20, 100, 15, property.m_6908_().stream().map(v -> property.m_6940_((Comparable) v)).toList(), -1)
                            .setValue(property.m_6940_(value))
                            .setOnChanged(newValue -> properties.put(property, (Comparable) property.m_6215_(newValue).get()))
                            .setButtonBackground(ResourceBorderTexture.BUTTON_COMMON)
                            .setBackground(new ColorRectTexture(0xffaaaaaa)));
                    group.addWidget(new LabelWidget(105, 6 + i * 20, property.m_61708_()));
                    i--;
                }
            }).setHoverBorderTexture(1, -1).setHoverTooltips("ldlib.gui.tips.block_meta"));
        }
    }

    public BlockState getBlock() {
        BlockState state;
        if (block == null) {
            state = null;
        } else {
            state = block.m_49966_();
            for (Map.Entry<Property, Comparable> entry : properties.entrySet()) {
                state = state.m_61124_(entry.getKey(), entry.getValue());
            }
        }
        return state;
    }

    public BlockSelectorWidget setBlock(BlockState blockState) {
        properties.clear();
        if (blockState == null) {
            block = null;
            handler.setStackInSlot(0, ItemStack.f_41583_);
            blockField.setCurrentString("");
        } else {
            block = blockState.m_60734_();
            new ItemStack(block);
            handler.setStackInSlot(0, new ItemStack(block));
            blockField.setCurrentString(BuiltInRegistries.f_256975_.m_7981_(block));
            for (Property<?> property : blockState.m_60734_().m_49965_().m_61092_()) {
                properties.put(property, blockState.m_61143_(property));
            }
        }
        return this;
    }

    public BlockSelectorWidget setOnBlockStateUpdate(Consumer<BlockState> onBlockStateUpdate) {
        this.onBlockStateUpdate = onBlockStateUpdate;
        return this;
    }

    private void onUpdate() {
        handler.setStackInSlot(0, block == null ? ItemStack.f_41583_ : new ItemStack(block));
        if (onBlockStateUpdate != null) {
            onBlockStateUpdate.accept(getBlock());
        }
    }
}
