package com.lowdragmc.lowdraglib.gui.widget;

import com.lowdragmc.lowdraglib.gui.texture.ColorBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

import java.util.Objects;
import java.util.function.Consumer;

public class ItemStackSelectorWidget extends WidgetGroup {
    private Consumer<ItemStack> onItemStackUpdate;
    private final IItemTransfer handler;
    private final TextFieldWidget itemField;
    private ItemStack item = ItemStack.f_41583_;

    public ItemStackSelectorWidget(int x, int y, int width) {
        this(x, y, width, true);
    }

    public ItemStackSelectorWidget(int x, int y, int width, boolean nbt) {
        super(x, y, width, 20);
        setClientSideWidget();
        itemField = (TextFieldWidget) new TextFieldWidget(22, 0, width - 46, 20, null, s -> {
            if (s != null && !s.isEmpty()) {
                Item item = BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(s));
                if (!ItemStack.m_150942_(item.m_7968_(), this.item)) {
                    this.item = item.m_7968_();
                    onUpdate();
                }
            }
        }).setResourceLocationOnly().setHoverTooltips("ldlib.gui.tips.item_selector");

        addWidget(new PhantomSlotWidget(handler = new ItemStackTransfer(1), 0, 1, 1)
                .setClearSlotOnRightClick(true)
                .setChangeListener(() -> {
                    setItemStack(handler.getStackInSlot(0));
                    onUpdate();
                }).setBackgroundTexture(new ColorBorderTexture(1, -1)));
        addWidget(itemField);

        if (nbt) {
            addWidget(new ButtonWidget(width - 21, 0, 20, 20, null, cd -> {
                if (item.m_41619_()) return;
                TextFieldWidget nbtField;
                new DialogWidget(getGui().mainGroup, isClientSideWidget)
                        .setOnClosed(this::onUpdate)
                        .addWidget(nbtField = new TextFieldWidget(10, 10, getGui().mainGroup.getSize().width - 50, 20, null, s -> {
                            try {
                                item.setTag(TagParser.parseTag(s));
                                onUpdate();
                            } catch (CommandSyntaxException ignored) {

                            }
                        }));
                if (item.m_41782_()) {
                    nbtField.setCurrentString(item.m_41783_().toString());
                }
            })
                    .setButtonTexture(ResourceBorderTexture.BUTTON_COMMON, new TextTexture("NBT", -1).setDropShadow(true))
                    .setHoverBorderTexture(1, -1).setHoverTooltips("ldlib.gui.tips.item_tag"));
        }
    }

    public ItemStack getItemStack() {
        return item;
    }

    public ItemStackSelectorWidget setItemStack(ItemStack itemStack) {
        item = Objects.requireNonNullElse(itemStack, ItemStack.f_41583_).m_41777_();
        handler.setStackInSlot(0, item);
        itemField.setCurrentString(BuiltInRegistries.f_257033_.m_7981_(item.m_41720_()).toString());
        return this;
    }

    public ItemStackSelectorWidget setOnItemStackUpdate(Consumer<ItemStack> onItemStackUpdate) {
        this.onItemStackUpdate = onItemStackUpdate;
        return this;
    }

    private void onUpdate() {
        handler.setStackInSlot(0, item);
        if (onItemStackUpdate != null) {
            onItemStackUpdate.accept(item);
        }
    }
}
