package com.lowdragmc.lowdraglib.gui.widget;

import com.google.common.collect.Lists;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.ingredient.IGhostIngredientTarget;
import com.lowdragmc.lowdraglib.gui.ingredient.Target;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.mojang.blaze3d.platform.InputConstants;
import dev.emi.emi.api.stack.EmiStack;
import lombok.Getter;
import lombok.Setter;
import mezz.jei.api.ingredients.ITypedIngredient;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.lwjgl.glfw.GLFW;

import javax.annotation.Nonnull;
import java.util.Collections;
import java.util.List;

@LDLRegister(name = "phantom_item_slot", group = "widget.container")
public class PhantomSlotWidget extends SlotWidget implements IGhostIngredientTarget, IConfigurableWidget {

    @Getter
    private boolean clearSlotOnRightClick;

    @Configurable(name = "ldlib.gui.editor.name.maxStackSize")
    @NumberRange(range = {0, 64})
    @Setter
    @Getter
    private int maxStackSize = 64;

    public PhantomSlotWidget() {
        super();
    }

    public PhantomSlotWidget(IItemTransfer itemHandler, int slotIndex, int xPosition, int yPosition) {
        super(itemHandler, slotIndex, xPosition, yPosition, true, true);
    }

    public PhantomSlotWidget setClearSlotOnRightClick(boolean clearSlotOnRightClick) {
        this.clearSlotOnRightClick = clearSlotOnRightClick;
        return this;
    }

    @ConfigSetter(field = "canTakeItems")
    public PhantomSlotWidget setCanTakeItems(boolean v) {
        // you cant modify it
        return this;
    }

    @ConfigSetter(field = "canPutItems")
    public PhantomSlotWidget setCanPutItems(boolean v) {
        // you cant modify it
        return this;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (slotReference != null && isMouseOverElement(mouseX, mouseY) && gui != null) {
            if (isClientSideWidget && !gui.getModularUIContainer().m_142621_().m_41619_()) {
                slotReference.m_5852_(gui.getModularUIContainer().m_142621_());
            } else if (button == 1 && clearSlotOnRightClick && !slotReference.m_7993_().m_41619_()) {
                slotReference.m_5852_(ItemStack.f_41583_);
                writeClientAction(2, buf -> {
                });
            } else {
                HOVER_SLOT = slotReference;
                gui.getModularUIGui().superMouseClicked(mouseX, mouseY, button);
                HOVER_SLOT = null;
            }
            return true;
        }
        return false;
    }

    @Override
    public ItemStack slotClick(int dragType, ClickType clickTypeIn, Player player) {
        if (slotReference != null && gui != null) {
            ItemStack stackHeld = gui.getModularUIContainer().m_142621_();
            return slotClickPhantom(slotReference, dragType, clickTypeIn, stackHeld);
        }
        return ItemStack.f_41583_;
    }

    @Override
    public boolean canMergeSlot(ItemStack stack) {
        return false;
    }

    @Override
    public boolean canTakeStack(Player player) {
        return false;
    }

    @Override
    public boolean canPutStack(ItemStack stack) {
        return false;
    }

    @Override
    @Environment(EnvType.CLIENT)
    public List<Target> getPhantomTargets(Object ingredient) {
        if (LDLib.isEmiLoaded() && ingredient instanceof EmiStack itemEmiStack) {
            Item item = itemEmiStack.getKeyOfType(Item.class);
            ingredient = item == null ? null : new ItemStack(item, (int)itemEmiStack.getAmount());
            if (ingredient instanceof ItemStack itemStack) {
                itemStack.m_41751_(itemEmiStack.getNbt());
            }
        }
        if (LDLib.isJeiLoaded() && ingredient instanceof ITypedIngredient<?> itemJeiStack) {
            ingredient = itemJeiStack.getItemStack().orElse(ItemStack.f_41583_);
        }
        if (!(ingredient instanceof ItemStack)) {
            return Collections.emptyList();
        }
        Rect2i rectangle = toRectangleBox();
        return Lists.newArrayList(new Target() {
            @Nonnull
            @Override
            public Rect2i getArea() {
                return rectangle;
            }

            @Override
            public void accept(@Nonnull Object ingredient) {
                if (LDLib.isEmiLoaded() && ingredient instanceof EmiStack itemEmiStack) {
                    Item item = itemEmiStack.getKeyOfType(Item.class);
                    ingredient = item == null ? null : new ItemStack(item, (int)itemEmiStack.getAmount());
                    if (ingredient instanceof ItemStack itemStack) {
                        itemStack.m_41751_(itemEmiStack.getNbt());
                    }
                }
                if (LDLib.isJeiLoaded() && ingredient instanceof ITypedIngredient<?> itemJeiStack) {
                    ItemStack itemStack = itemJeiStack.getItemStack().orElse(ItemStack.f_41583_);
                    if (!itemStack.m_41619_()) {
                        ingredient = itemStack;
                    }
                }
                if (slotReference != null && ingredient instanceof ItemStack stack) {
                    long id = Minecraft.m_91087_().m_91268_().m_85439_();
                    boolean shiftDown = InputConstants.m_84830_(id, GLFW.GLFW_KEY_LEFT_SHIFT) || InputConstants.m_84830_(id, GLFW.GLFW_KEY_LEFT_SHIFT);
                    ClickType clickType = shiftDown ? ClickType.QUICK_MOVE : ClickType.PICKUP;
                    slotClickPhantom(slotReference, 0, clickType, stack);
                    writeClientAction(1, buffer -> {
                        buffer.m_130055_(stack);
                        buffer.m_130130_(0);
                        buffer.writeBoolean(shiftDown);
                    });
                }
            }
        });
    }

    @Override
    public void handleClientAction(int id, FriendlyByteBuf buffer) {
        if (slotReference != null && id == 1) {
            ItemStack stackHeld;
            stackHeld = buffer.m_130267_();
            int mouseButton = buffer.m_130242_();
            boolean shiftKeyDown = buffer.readBoolean();
            ClickType clickType = shiftKeyDown ? ClickType.QUICK_MOVE : ClickType.PICKUP;
            slotClickPhantom(slotReference, mouseButton, clickType, stackHeld);
        } else if (slotReference != null && id == 2) {
            slotReference.m_5852_(ItemStack.f_41583_);
        }
    }

    public ItemStack slotClickPhantom(Slot slot, int mouseButton, ClickType clickTypeIn, ItemStack stackHeld) {
        ItemStack stack = ItemStack.f_41583_;

        ItemStack stackSlot = slot.m_7993_();
        if (!stackSlot.m_41619_()) {
            stack = stackSlot.m_41777_();
        }

        if (mouseButton == 2) {
            fillPhantomSlot(slot, ItemStack.f_41583_, mouseButton);
        } else if (mouseButton == 0 || mouseButton == 1) {

            if (stackSlot.m_41619_()) {
                if (!stackHeld.m_41619_() ) {
                    fillPhantomSlot(slot, stackHeld, mouseButton);
                }
            } else if (stackHeld.m_41619_()) {
                adjustPhantomSlot(slot, mouseButton, clickTypeIn);
            } else  {
                if (!areItemsEqual(stackSlot, stackHeld)) {
                    adjustPhantomSlot(slot, mouseButton, clickTypeIn);
                }
                fillPhantomSlot(slot, stackHeld, mouseButton);
            }
        } else if (mouseButton == 5) {
            if (!slot.m_6657_()) {
                fillPhantomSlot(slot, stackHeld, mouseButton);
            }
        }
        return stack;
    }

    private void adjustPhantomSlot(Slot slot, int mouseButton, ClickType clickTypeIn) {
        ItemStack stackSlot = slot.m_7993_();
        int stackSize;
        if (clickTypeIn == ClickType.QUICK_MOVE) {
            stackSize = mouseButton == 0 ? (stackSlot.m_41613_() + 1) / 2 : stackSlot.m_41613_() * 2;
        } else {
            stackSize = mouseButton == 0 ? stackSlot.m_41613_() - 1 : stackSlot.m_41613_() + 1;
        }

        if (stackSize > slot.m_6641_()) {
            stackSize = slot.m_6641_();
        }

        stackSlot.m_41764_(Math.min(maxStackSize, stackSize));

        slot.m_5852_(stackSlot);
    }

    private void fillPhantomSlot(Slot slot, ItemStack stackHeld, int mouseButton) {
        if (stackHeld.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
            return;
        }

        int stackSize = mouseButton == 0 ? stackHeld.m_41613_() : 1;
        if (stackSize > slot.m_6641_()) {
            stackSize = slot.m_6641_();
        }
        ItemStack phantomStack = stackHeld.m_41777_();
        phantomStack.m_41764_(Math.min(maxStackSize, stackSize));
        slot.m_5852_(phantomStack);
    }

    public boolean areItemsEqual(ItemStack itemStack1, ItemStack itemStack2) {
        return ItemStack.m_41728_(itemStack1, itemStack2);
    }
}