package com.lowdragmc.lowdraglib.gui.widget.codeeditor.language;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import lombok.Getter;
import lombok.Setter;
import net.minecraft.network.chat.Style;

import java.util.HashMap;
import java.util.Map;

@Getter
public class StyleManager {
    private final Map<String, Style> styleMap = new HashMap<>();
    @Setter
    public Style defaultStyle = Style.f_131099_.m_178520_(-1);

    public StyleManager() {
        styleMap.put(TokenTypes.KEYWORD.name, Style.f_131099_.m_178520_(ColorPattern.ORANGE.color));
        styleMap.put(TokenTypes.IDENTIFIER.name, Style.f_131099_.m_178520_(ColorPattern.WHITE.color));
        styleMap.put(TokenTypes.STRING.name, Style.f_131099_.m_178520_(ColorPattern.GREEN.color));
        styleMap.put(TokenTypes.COMMENT.name, Style.f_131099_.m_178520_(ColorPattern.GRAY.color));
        styleMap.put(TokenTypes.NUMBER.name, Style.f_131099_.m_178520_(ColorPattern.CYAN.color));
        styleMap.put(TokenTypes.OPERATOR.name, Style.f_131099_.m_178520_(ColorPattern.WHITE.color));
    }

    public Style getStyleForTokenType(TokenType type) {
        return styleMap.getOrDefault(type.name, defaultStyle);
    }
}