package com.lowdragmc.lowdraglib.jei;

import com.mojang.blaze3d.systems.RenderSystem;
import mezz.jei.api.gui.widgets.IRecipeWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.navigation.ScreenPosition;

import java.util.Optional;

public class ModularForegroundRecipeWidget implements IRecipeWidget {
    public final ModularWrapper<?> modular;

    public ModularForegroundRecipeWidget(ModularWrapper<?> modular) {
        this.modular = modular;
    }

    @Override
    public ScreenPosition getPosition() {
        return new ScreenPosition(0, 0);
    }

    @Override
    public void draw(GuiGraphics graphics, double mouseX, double mouseY) {
        float partialTick = Minecraft.m_91087_().m_91296_();

        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85837_(-modular.getLeft(), -modular.getTop(), 0);

        RenderSystem.disableDepthTest();
        RenderSystem.depthMask(false);

        modular.modularUI.mainGroup.drawInForeground(graphics, (int) mouseX, (int) mouseY, partialTick);
        modular.modularUI.mainGroup.drawOverlay(graphics, (int) mouseX, (int) mouseY, partialTick);

        // do not draw tooltips here, do it from recipe viewer.
        if (modular.isShouldRenderTooltips() && modular.tooltipTexts != null && !modular.tooltipTexts.isEmpty()) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0, 0, 240);
            graphics.m_280677_(Minecraft.m_91087_().f_91062_, modular.tooltipTexts, Optional.ofNullable(modular.tooltipComponent), (int) mouseX, (int) mouseY);
            graphics.m_280168_().m_85849_();
            graphics.m_280091_().m_173043_();
        }

        RenderSystem.depthMask(true);
        RenderSystem.enableDepthTest();

        graphics.m_280168_().m_85849_();
    }
}
