package com.lowdragmc.lowdraglib.jei;

import lombok.Getter;
import mezz.jei.api.gui.inputs.IJeiGuiEventListener;
import net.minecraft.client.gui.navigation.ScreenRectangle;

public class ModularUIGuiEventListener<T extends ModularWrapper<?>> implements IJeiGuiEventListener {

    private final ModularWrapper<?> wrapper;
    @Getter
    private final ScreenRectangle area;

    public ModularUIGuiEventListener(ModularWrapper<?> wrapper) {
        this.wrapper = wrapper;
        this.area = new ScreenRectangle(0, 0, wrapper.modularUI.getWidth(), wrapper.modularUI.getHeight());
    }

    @Override
    public void mouseMoved(double mouseX, double mouseY) {
        wrapper.m_94757_(mouseX, mouseY);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return wrapper.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        return wrapper.m_6348_(mouseX, mouseY, button);
    }

    @Override
    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return wrapper.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double scrollDelta) {
        return wrapper.m_6050_(mouseX, mouseY, scrollDelta);
    }

    @Override
    public boolean keyPressed(double mouseX, double mouseY, int keyCode, int scanCode, int modifiers) {
        return wrapper.m_7933_(keyCode, scanCode, modifiers);
    }
}
