package com.lowdragmc.lowdraglib.jei;

import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.modular.ModularUIGuiContainer;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.utils.Position;
import com.mojang.blaze3d.systems.RenderSystem;
import lombok.Getter;
import lombok.Setter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;
import org.lwjgl.opengl.GL11;

import javax.annotation.Nonnull;
import java.util.Optional;

@Environment(EnvType.CLIENT)
public class ModularWrapper<T extends Widget> extends ModularUIGuiContainer {
    @Getter
    protected T widget;
    @Getter @Setter
    protected boolean shouldRenderTooltips = false;

    public ModularWrapper(T widget) {
        super(new ModularUI(widget.getSize().width, widget.getSize().height, IUIHolder.EMPTY, Minecraft.m_91087_().f_91074_).widget(widget), -1);
        modularUI.initWidgets();
        this.f_96541_ = Minecraft.m_91087_();
        this.f_96547_ = f_96541_.f_91062_;
        this.widget = widget;
    }

    private int lastTick;
    @Getter
    private int left, top;

    public String getUid() {
        return null;
    }

    /**
     * For REI to use
     */
    public void setRecipeWidget(int left, int top) {
        modularUI.initWidgets();
        this.left = 0;
        this.top = 0;
        this.f_96543_ = f_96541_.m_91268_().m_85445_();
        this.f_96544_ = f_96541_.m_91268_().m_85446_();
        modularUI.updateScreenSize(this.f_96543_, this.f_96544_);
        Position displayOffset = new Position(left, top);
        modularUI.mainGroup.setParentPosition(displayOffset);
    }

    public void setEmiRecipeWidget(int left, int top) {
        modularUI.initWidgets();
        this.left = left;
        this.top = top;
        this.f_96543_ = f_96541_.m_91268_().m_85445_();
        this.f_96544_ = f_96541_.m_91268_().m_85446_();
        modularUI.updateScreenSize(this.f_96543_, this.f_96544_);
        Position displayOffset = new Position(left, top);
        modularUI.mainGroup.setParentPosition(displayOffset);
    }

    public void draw(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (f_96541_.f_91074_.f_19797_ != lastTick) {
            updateScreen();
            lastTick = f_96541_.f_91074_.f_19797_;
        }
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(-left, -top, 0);
        m_88315_(graphics, mouseX + left, mouseY + top, partialTicks);
        graphics.m_280168_().m_85849_();
    }

    public void updateScreen() {
        modularUI.mainGroup.updateScreen();
    }

    @Override
    public void m_88315_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.f_97734_ = null;

        RenderSystem.disableDepthTest();
        RenderSystem.depthMask(false);

        tooltipTexts = null;
        tooltipFont = null;
        tooltipStack = ItemStack.f_41583_;
        tooltipComponent = null;

        modularUI.mainGroup.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        modularUI.mainGroup.drawInForeground(graphics, mouseX, mouseY, partialTicks);

        // do not draw tooltips here, do it from recipe viewer.
        if (shouldRenderTooltips && tooltipTexts != null && !tooltipTexts.isEmpty()) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0, 0, 240);
            graphics.m_280677_(f_96547_, tooltipTexts, Optional.ofNullable(tooltipComponent), mouseX, mouseY);
            graphics.m_280168_().m_85849_();
            graphics.m_280091_().m_173043_();
        }

        RenderSystem.depthMask(true);
        RenderSystem.enableDepthTest();

        RenderSystem.clear(GL11.GL_DEPTH_BUFFER_BIT, Minecraft.f_91002_);
    }

}
