package com.lowdragmc.lowdraglib.kjs.ui;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.factory.UIFactory;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.level.BlockContainerJS;
import dev.latvian.mods.kubejs.typings.Info;
import dev.latvian.mods.rhino.util.RemapForJS;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class BlockUIJSFactory extends UIFactory<BlockUIJSFactory.BlockAccess> {
    public static final BlockUIJSFactory INSTANCE = new BlockUIJSFactory();
    public record BlockAccess(BlockPos pos, String uiName) { }

    private BlockUIJSFactory() {
        super(LDLib.location("block_js"));
    }

    @RemapForJS("openUI")
    @Info("Opens a UI for a player at a specific block position.")
    public boolean kjs$openUI(Player player, BlockPos pos, String uiName) {
        if (player instanceof ServerPlayer serverPlayer) {
            return openUI(new BlockAccess(pos, uiName), serverPlayer);
        }
        return false;
    }

    @Override
    protected ModularUI createUITemplate(BlockAccess holder, Player entityPlayer) {
        var level = entityPlayer.m_9236_();
        var pos = holder.pos;
        var block = level.m_8055_(pos);
        var blockEntity = level.m_7702_(pos);
        var result = UIEvents.BLOCK.post(new UIEvents.BlockUIEventJS(level, pos, new BlockContainerJS(level, pos), entityPlayer), holder.uiName);
        if (result.value() instanceof WidgetGroup root && !result.interruptFalse() && !result.error()) {
            return new ModularUI(root, new IUIHolder() {
                @Override
                public ModularUI createUI(Player entityPlayer) {
                    return null;
                }

                @Override
                public boolean isInvalid() {
                    if (blockEntity != null && blockEntity.m_58901_()) return true;
                    return !level.m_8055_(pos).m_60713_(block.m_60734_());
                }

                @Override
                public boolean isRemote() {
                    return level.f_46443_;
                }

                @Override
                public void markAsDirty() {
                    if (blockEntity != null) blockEntity.m_6596_();
                }
            }, entityPlayer);
        }
        return null;
    }

    @Environment(EnvType.CLIENT)
    @Override
    protected BlockAccess readHolderFromSyncData(FriendlyByteBuf syncData) {
        return new BlockAccess(syncData.m_130135_(), syncData.m_130277_());
    }

    @Override
    protected void writeHolderToSyncData(FriendlyByteBuf syncData, BlockAccess holder) {
        syncData.m_130064_(holder.pos());
        syncData.m_130070_(holder.uiName());
    }
}
