package com.lowdragmc.lowdraglib.misc;

import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import lombok.Getter;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

import javax.annotation.Nonnull;

/**
 * @author KilaBash
 * @date 2023/2/10
 * @implNote InventoryItemTransfer
 */
public class ContainerTransfer implements IItemTransfer {
    @Getter
    private final Container inv;

    public ContainerTransfer(Container inv) {
        this.inv = inv;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o)
            return true;
        if (o == null || getClass() != o.getClass())
            return false;

        ContainerTransfer that = (ContainerTransfer) o;

        return getInv().equals(that.getInv());

    }

    @Override
    public int hashCode() {
        return getInv().hashCode();
    }

    @Override
    public int getSlots() {
        return getInv().getContainerSize();
    }

    @Override
    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return getInv().getItem(slot);
    }

    @Override
    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate, boolean notifyChanges) {
        if (stack.m_41619_())
            return ItemStack.f_41583_;

        ItemStack stackInSlot = getInv().getItem(slot);

        int m;
        if (!stackInSlot.m_41619_()) {
            if (stackInSlot.m_41613_() >= Math.min(stackInSlot.m_41741_(), getSlotLimit(slot)))
                return stack;

            if (!ItemHandlerHelper.canItemStacksStack(stack, stackInSlot))
                return stack;

            if (!getInv().canPlaceItem(slot, stack))
                return stack;

            m = Math.min(stack.m_41741_(), getSlotLimit(slot)) - stackInSlot.m_41613_();

            if (stack.m_41613_() <= m) {
                if (!simulate) {
                    ItemStack copy = stack.m_41777_();
                    copy.m_41769_(stackInSlot.m_41613_());
                    getInv().setItem(slot, copy);
                    if (notifyChanges) {
                        onContentsChanged();
                    }
                    getInv().setChanged();
                }

                return ItemStack.f_41583_;
            } else {
                // copy the stack to not modify the original one
                stack = stack.m_41777_();
                if (!simulate) {
                    ItemStack copy = stack.m_41620_(m);
                    copy.m_41769_(stackInSlot.m_41613_());
                    getInv().setItem(slot, copy);
                    if (notifyChanges) {
                        onContentsChanged();
                    }
                    getInv().setChanged();
                    return stack;
                } else {
                    stack.m_41774_(m);
                    return stack;
                }
            }
        } else {
            if (!getInv().canPlaceItem(slot, stack))
                return stack;

            m = Math.min(stack.m_41741_(), getSlotLimit(slot));
            if (m < stack.m_41613_()) {
                // copy the stack to not modify the original one
                stack = stack.m_41777_();
                if (!simulate) {
                    getInv().setItem(slot, stack.m_41620_(m));
                    if (notifyChanges) {
                        onContentsChanged();
                    }
                    getInv().setChanged();
                    return stack;
                } else {
                    stack.m_41774_(m);
                    return stack;
                }
            } else {
                if (!simulate) {
                    getInv().setItem(slot, stack);
                    if (notifyChanges) {
                        onContentsChanged();
                    }
                    getInv().setChanged();
                }
                return ItemStack.f_41583_;
            }
        }

    }

    @Override
    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate, boolean notifyChanges) {
        if (amount == 0)
            return ItemStack.f_41583_;

        ItemStack stackInSlot = getInv().getItem(slot);

        if (stackInSlot.m_41619_())
            return ItemStack.f_41583_;

        if (simulate) {
            if (stackInSlot.m_41613_() < amount) {
                return stackInSlot.m_41777_();
            } else {
                ItemStack copy = stackInSlot.m_41777_();
                copy.m_41764_(amount);
                return copy;
            }
        } else {
            int m = Math.min(stackInSlot.m_41613_(), amount);

            ItemStack decrStackSize = getInv().removeItem(slot, m);
            if (notifyChanges) {
                onContentsChanged();
            }
            getInv().setChanged();
            return decrStackSize;
        }
    }

    @Override
    public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
        getInv().setItem(slot, stack);
    }

    @Override
    public int getSlotLimit(int slot) {
        return getInv().getMaxStackSize();
    }

    @Override
    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return getInv().canPlaceItem(slot, stack);
    }

    @NotNull
    @Override
    public Object createSnapshot() {
        ItemStack[] copied = new ItemStack[inv.m_6643_()];
        for (int i = 0; i < inv.m_6643_(); i++) {
            copied[i] = inv.m_8020_(i).m_41777_();
        }
        return copied;
    }

    @Override
    public void restoreFromSnapshot(Object snapshot) {
        if (snapshot instanceof ItemStack[] copied && copied.length == inv.m_6643_()) {
            for (int i = 0; i < inv.m_6643_(); i++) {
                inv.m_6836_(i, copied[i]);
            }
        }
    }
}
