package com.lowdragmc.lowdraglib.rei;

import com.lowdragmc.lowdraglib.jei.ModularWrapper;
import com.mojang.blaze3d.systems.RenderSystem;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import org.lwjgl.opengl.GL11;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class ModularForegroundRenderWidget extends Widget {
    public final ModularWrapper<?> modular;

    public ModularForegroundRenderWidget(ModularWrapper<?> modular) {
        this.modular = modular;
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85837_(-modular.getLeft(), -modular.getTop(), 0);

        RenderSystem.disableDepthTest();
        RenderSystem.depthMask(false);

        modular.modularUI.mainGroup.drawInForeground(graphics, mouseX, mouseY, partialTick);
        modular.modularUI.mainGroup.drawOverlay(graphics, mouseX, mouseY, partialTick);

        // do not draw tooltips here, do it from recipe viewer.
        if (modular.isShouldRenderTooltips() && modular.tooltipTexts != null && !modular.tooltipTexts.isEmpty()) {
            graphics.m_280168_().m_85836_();
            graphics.m_280168_().m_252880_(0, 0, 240);
            graphics.m_280677_(Minecraft.m_91087_().f_91062_, modular.tooltipTexts, Optional.ofNullable(modular.tooltipComponent), mouseX, mouseY);
            graphics.m_280168_().m_85849_();
            graphics.m_280091_().m_173043_();
        }

        RenderSystem.depthMask(true);
        RenderSystem.enableDepthTest();

        RenderSystem.clear(GL11.GL_DEPTH_BUFFER_BIT, Minecraft.f_91002_);

        graphics.m_280168_().m_85849_();

    }

    @Override
    public List<? extends GuiEventListener> m_6702_() {
        return Collections.emptyList();
    }
}
