package com.lowdragmc.lowdraglib.rei;

import com.lowdragmc.lowdraglib.jei.ModularWrapper;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.TooltipContext;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.jetbrains.annotations.Nullable;

import javax.annotation.Nonnull;
import java.util.Collections;
import java.util.List;

/**
 * @author KilaBash
 * @date 2022/11/27
 * @implNote ModularWrapperWidget
 */
@Environment(EnvType.CLIENT)
public class ModularWrapperWidget extends Widget {
    final ModularWrapper<?> modular;

    public ModularWrapperWidget(ModularWrapper<?> modular) {
        this.modular = modular;
    }

    @Override
    public void m_88315_(@Nonnull GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        modular.draw(graphics, pMouseX, pMouseY, pPartialTick);
        var tooltip = getTooltip(TooltipContext.ofMouse());
        if (tooltip != null) {
            tooltip.queue();
        }
    }

    @Override
    @Nullable
    public Tooltip getTooltip(TooltipContext context) {
        if (modular.tooltipTexts != null && !modular.tooltipTexts.isEmpty()) {
            var tooltip = Tooltip.create(context.getPoint(), modular.tooltipTexts);
            if (modular.tooltipComponent != null) {
                tooltip.add(modular.tooltipComponent);
            }
            return tooltip;
        }
        return null;
    }

    @Override
    public List<? extends GuiEventListener> m_6702_() {
        return Collections.emptyList();
    }

    @Override
    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        return modular.m_6375_(pMouseX, pMouseY, pButton);
    }

    @Override
    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        return modular.m_6348_(pMouseX, pMouseY, pButton);
    }

    @Override
    public void m_94757_(double pMouseX, double pMouseY) {
        modular.m_94757_(pMouseX, pMouseY);
    }

    @Override
    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        return modular.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    @Override
    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        return modular.m_6050_(pMouseX, pMouseY, pDelta);
    }

    @Override
    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        modular.focused = false;
        if (modular.modularUI.mainGroup.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return false;
        }
        return super.m_7933_(pKeyCode, pScanCode, pModifiers);
    }

    @Override
    public boolean m_7920_(int pKeyCode, int pScanCode, int pModifiers) {
        return modular.m_7920_(pKeyCode, pScanCode, pModifiers);
    }

    @Override
    public boolean m_5534_(char pCodePoint, int pModifiers) {
        return modular.m_5534_(pCodePoint, pModifiers);
    }
}
