package com.lowdragmc.lowdraglib.side.item;

import com.lowdragmc.lowdraglib.misc.PlayerInventoryTransfer;
import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.function.Predicate;

/**
 * @author KilaBash
 * @date 2023/2/10
 * @implNote ItemTransferHelper
 */
public class ItemTransferHelper {

    @ExpectPlatform
    public static IItemTransfer getItemTransfer(Level level, BlockPos pos, @Nullable Direction direction) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void exportToTarget(IItemTransfer source, int maxAmount, Predicate<ItemStack> predicate, Level level, BlockPos pos, @Nullable Direction direction) {
        throw new AssertionError();
    }

    @ExpectPlatform
    public static void importToTarget(IItemTransfer target, int maxAmount, Predicate<ItemStack> predicate, Level level, BlockPos pos, @Nullable Direction direction) {
        throw new AssertionError();
    }

    public static boolean canItemStacksStack(ItemStack first, ItemStack second) {
        if (!first.m_41619_() && ItemStack.m_41656_(first, second) && first.m_41782_() == second.m_41782_()) {
            return !first.m_41782_() || first.m_41783_().equals(second.m_41783_());
        } else {
            return false;
        }
    }

    public static ItemStack copyStackWithSize(ItemStack stack, int size) {
        if (size == 0) {
            return ItemStack.f_41583_;
        } else {
            ItemStack copy = stack.m_41777_();
            copy.m_41764_(size);
            return copy;
        }
    }

    @Nonnull
    public static ItemStack insertItem(IItemTransfer dest, @Nonnull ItemStack stack, boolean simulate) {
        if (dest == null || stack.m_41619_())
            return stack;

        for (int i = 0; i < dest.getSlots(); i++) {
            stack = dest.insertItem(i, stack, simulate);
            if (stack.m_41619_()) {
                return ItemStack.f_41583_;
            }
        }

        return stack;
    }

    /**
     * Inserts the ItemStack into the inventory, filling up already present stacks first.
     * This is equivalent to the behaviour of a player picking up an item.
     * Note: This function stacks items without subtypes with different metadata together.
     */
    @Nonnull
    public static ItemStack insertItemStacked(IItemTransfer inventory, ItemStack stack, boolean simulate) {
        if (inventory == null || stack.m_41619_())
            return stack;

        // not stackable -> just insert into a new slot
        if (!stack.m_41753_()) {
            return insertItem(inventory, stack, simulate);
        }

        int sizeInventory = inventory.getSlots();

        // go through the inventory and try to fill up already existing items
        for (int i = 0; i < sizeInventory; i++) {
            ItemStack slot = inventory.getStackInSlot(i);
            if (canItemStacksStackRelaxed(slot, stack)) {
                stack = inventory.insertItem(i, stack, simulate);

                if (stack.m_41619_()) {
                    break;
                }
            }
        }

        // insert remainder into empty slots
        if (!stack.m_41619_()) {
            // find empty slot
            for (int i = 0; i < sizeInventory; i++) {
                if (inventory.getStackInSlot(i).m_41619_()) {
                    stack = inventory.insertItem(i, stack, simulate);
                    if (stack.m_41619_()) {
                        break;
                    }
                }
            }
        }

        return stack;
    }


    /**
     * A relaxed version of canItemStacksStack that stacks itemstacks with different metadata if they don't have subtypes.
     * This usually only applies when players pick up items.
     */
    public static boolean canItemStacksStackRelaxed(@Nonnull ItemStack a, @Nonnull ItemStack b) {
        if (a.m_41619_() || b.m_41619_() || a.m_41720_() != b.m_41720_())
            return false;

        if (!a.m_41753_())
            return false;

        if (a.m_41782_() != b.m_41782_())
            return false;

        return (!a.m_41782_() || a.m_41783_().equals(b.m_41783_()));
    }

    public static void giveItemToPlayer(Player player, ItemStack stack) {
        giveItemToPlayer(player, stack, -1);
    }


    /**
     * Inserts the given itemstack into the players inventory.
     * If the inventory can't hold it, the item will be dropped in the world at the players position.
     *
     * @param player The player to give the item to
     * @param stack  The itemstack to insert
     */
    public static void giveItemToPlayer(Player player, @Nonnull ItemStack stack, int preferredSlot) {
        if (stack.m_41619_()) return;

        IItemTransfer inventory = new PlayerInventoryTransfer(player.m_150109_());
        Level level = player.m_9236_();

        // try adding it into the inventory
        ItemStack remainder = stack;
        // insert into preferred slot first
        if (preferredSlot >= 0 && preferredSlot < inventory.getSlots()) {
            remainder = inventory.insertItem(preferredSlot, stack, false);
        }
        // then into the inventory in general
        if (!remainder.m_41619_()) {
            remainder = insertItemStacked(inventory, remainder, false);
        }

        // play sound if something got picked up
        if (remainder.m_41619_() || remainder.m_41613_() != stack.m_41613_()) {
            level.m_6263_(null, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(),
                    SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2F, ((level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.7F + 1.0F) * 2.0F);
        }

        // drop remaining itemstack into the level
        if (!remainder.m_41619_() && !level.f_46443_) {
            ItemEntity entityitem = new ItemEntity(level, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), remainder);
            entityitem.m_32010_(40);
            entityitem.m_20256_(entityitem.m_20184_().m_82542_(0, 1, 0));

            level.m_7967_(entityitem);
        }
    }
}
