package com.lowdragmc.lowdraglib.syncdata.accessor;

import com.lowdragmc.lowdraglib.syncdata.AccessorOp;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import com.lowdragmc.lowdraglib.syncdata.payload.NbtTagPayload;
import net.minecraft.core.Registry;
import net.minecraft.nbt.StringTag;
import net.minecraft.resources.ResourceLocation;

import java.util.Optional;

public class BuiltinRegistryAccessor<T> extends CustomObjectAccessor<T>{

    Registry<T> registry;

    public BuiltinRegistryAccessor(Class<T> clazz, Registry<T> registry) {
        super(clazz, true);
        this.registry = registry;
    }

    @Override
    public ITypedPayload<?> serialize(AccessorOp op, T value) {
        return NbtTagPayload.of(StringTag.m_129297_(Optional.ofNullable(registry.m_7981_(value))
                .map(ResourceLocation::toString).orElse("")));
    }

    @Override
    public T deserialize(AccessorOp op, ITypedPayload<?> payload) {
        if (payload instanceof NbtTagPayload nbtTagPayload) {
            var key = nbtTagPayload.getPayload().m_7916_();
            return key.isEmpty() ? null : registry.m_7745_(new ResourceLocation(key));
        }
        return null;
    }
}
