package com.lowdragmc.lowdraglib.syncdata.accessor;

import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.UIResourceTexture;
import com.lowdragmc.lowdraglib.syncdata.AccessorOp;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import com.lowdragmc.lowdraglib.syncdata.payload.NbtTagPayload;
import com.mojang.datafixers.util.Either;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import java.io.File;

/**
 * @author KilaBash
 * @date 2022/9/7
 * @implNote BlockStateAccessor
 */
public class IGuiTextureAccessor extends CustomObjectAccessor<IGuiTexture>{

    public IGuiTextureAccessor() {
        super(IGuiTexture.class, true);
    }

    @Override
    public ITypedPayload<?> serialize(AccessorOp op, IGuiTexture value) {
        var tag = IGuiTexture.serializeWrapper(value);
        if (tag == null) {
            tag = new CompoundTag();
            if (value instanceof UIResourceTexture uiResourceTexture) {
                tag.m_128359_("type", "ui_resource");
                tag.m_128365_("key", uiResourceTexture.key.map(
                        l -> {
                            var key = new CompoundTag();
                            key.m_128359_("key", l);
                            key.m_128359_("type", "builtin");
                            return key;
                        }, r-> {
                            var key = new CompoundTag();
                            key.m_128359_("key", r.getPath());
                            key.m_128359_("type", "project");
                            return key;
                        }
                ));
            } else {
                tag.m_128359_("type", "empty");
            }
        }
        return NbtTagPayload.of(tag);
    }

    @Override
    public IGuiTexture deserialize(AccessorOp op, ITypedPayload<?> payload) {
        if (payload instanceof NbtTagPayload nbtTagPayload) {
            var tag = (CompoundTag)nbtTagPayload.getPayload();
            var type = tag.m_128461_("type");
            if (type.equals("ui_resource") && tag.m_128441_("key")) {
                var keyTag = tag.m_128423_("key");
                Either<String, File> key = null;
                if (keyTag instanceof CompoundTag compoundTag) {
                    var keyType = compoundTag.m_128461_("type");
                    var keyValue = compoundTag.m_128461_("key");
                    if (keyType.equals("builtin")) {
                        key = Either.left(keyValue);
                    } else if (keyType.equals("project")) {
                        key = Either.right(new File(keyValue));
                    }
                } else if (keyTag != null){
                    key = Either.left(keyTag.m_7916_());
                }
                var resource = UIResourceTexture.getProjectResource();
                if (resource == null) {
                    return new UIResourceTexture(key);
                }
                if (UIResourceTexture.isProject()) {
                    return new UIResourceTexture(resource, key);
                } else {
                    return key == null ? IGuiTexture.MISSING_TEXTURE: resource.getResourceOrDefault(key, IGuiTexture.MISSING_TEXTURE);
                }
            }
            return IGuiTexture.deserializeWrapper(tag);
        }
        return null;
    }

}
