package com.lowdragmc.lowdraglib.syncdata.accessor;

import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.client.renderer.ISerializableRenderer;
import com.lowdragmc.lowdraglib.client.renderer.impl.UIResourceRenderer;
import com.lowdragmc.lowdraglib.syncdata.AccessorOp;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import com.lowdragmc.lowdraglib.syncdata.payload.NbtTagPayload;
import com.mojang.datafixers.util.Either;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import java.io.File;

public class IRendererAccessor extends CustomObjectAccessor<IRenderer> {

    public IRendererAccessor() {
        super(IRenderer.class, true);
    }

    @Override
    public ITypedPayload<?> serialize(AccessorOp op, IRenderer value) {
        if (value instanceof ISerializableRenderer serializableRenderer) {
            return NbtTagPayload.of(ISerializableRenderer.serializeWrapper(serializableRenderer));
        } else if (value instanceof UIResourceRenderer renderer) {
            var tag = new CompoundTag();
            tag.m_128359_("_type", "ui_resource");
            tag.m_128365_("key", renderer.key.map(
                    l -> {
                        var key = new CompoundTag();
                        key.m_128359_("key", l);
                        key.m_128359_("type", "builtin");
                        return key;
                    }, r-> {
                        var key = new CompoundTag();
                        key.m_128359_("key", r.getPath());
                        key.m_128359_("type", "project");
                        return key;
                    }
            ));
            return NbtTagPayload.of(tag);
        }
        return NbtTagPayload.of(new CompoundTag());
    }

    @Override
    public IRenderer deserialize(AccessorOp op, ITypedPayload<?> payload) {
        if (payload instanceof NbtTagPayload nbtTagPayload && nbtTagPayload.getPayload() instanceof CompoundTag tag) {
            if (tag.m_128441_("_type") && tag.m_128461_("_type").equals("ui_resource")) {
                var keyTag = tag.m_128423_("key");
                Either<String, File> key = null;
                if (keyTag instanceof CompoundTag compoundTag) {
                    var keyType = compoundTag.m_128461_("type");
                    var keyValue = compoundTag.m_128461_("key");
                    if (keyType.equals("builtin")) {
                        key = Either.left(keyValue);
                    } else if (keyType.equals("project")) {
                        key = Either.right(new File(keyValue));
                    }
                } else if (keyTag != null){
                    key = Either.left(keyTag.m_7916_());
                }
                var resource = UIResourceRenderer.getProjectResource();
                if (resource == null) {
                    return new UIResourceRenderer(key);
                }
                if (UIResourceRenderer.isProject()) {
                    return new UIResourceRenderer(resource, key);
                } else {
                    return key == null ? IRenderer.EMPTY : resource.getResourceOrDefault(key, IRenderer.EMPTY);
                }
            }
            var renderer = ISerializableRenderer.deserializeWrapper(tag);
            if (renderer != null) {
                return renderer;
            }
        }
        return IRenderer.EMPTY;
    }

}
