package com.lowdragmc.lowdraglib.syncdata.accessor;

import com.lowdragmc.lowdraglib.syncdata.AccessorOp;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import com.lowdragmc.lowdraglib.syncdata.payload.NbtTagPayload;
import com.lowdragmc.lowdraglib.utils.Range;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

/**
 * @author KilaBash
 * @date 2022/9/7
 * @implNote RangeAccessor
 */
public class RangeAccessor extends CustomObjectAccessor<Range>{

    public RangeAccessor() {
        super(Range.class, true);
    }

    @Override
    public ITypedPayload<?> serialize(AccessorOp op, Range value) {
        CompoundTag tag = new CompoundTag();
        if (value.getA() instanceof Float || value.getA() instanceof Double) {
            tag.m_128350_("a", value.getA().floatValue());
        } else {
            tag.m_128405_("a", value.getA().intValue());
        }
        if (value.getB() instanceof Float || value.getB() instanceof Double) {
            tag.m_128350_("b", value.getB().floatValue());
        } else {
            tag.m_128405_("b", value.getB().intValue());
        }
        return NbtTagPayload.of(tag);
    }

    @Override
    public Range deserialize(AccessorOp op, ITypedPayload<?> payload) {
        if (payload instanceof NbtTagPayload nbtTagPayload && nbtTagPayload.getPayload() instanceof CompoundTag tag) {
            Number a, b;
            if (tag.m_128425_("a", Tag.f_178196_)) {
                a = tag.m_128451_("a");
            } else {
                a = tag.m_128457_("a");
            }
            if (tag.m_128425_("b", Tag.f_178196_)) {
                b = tag.m_128451_("b");
            } else {
                b = tag.m_128457_("b");
            }
            return new Range(a, b);
        }
        return null;
    }
}
