package com.lowdragmc.lowdraglib.syncdata.accessor;

import com.lowdragmc.lowdraglib.syncdata.AccessorOp;
import com.lowdragmc.lowdraglib.syncdata.IAccessor;
import com.lowdragmc.lowdraglib.syncdata.TypedPayloadRegistries;
import com.lowdragmc.lowdraglib.syncdata.managed.IRef;
import com.lowdragmc.lowdraglib.syncdata.managed.ReadOnlyManagedField;
import com.lowdragmc.lowdraglib.syncdata.managed.ReadOnlyManagedRef;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import com.lowdragmc.lowdraglib.syncdata.payload.NbtTagPayload;
import com.lowdragmc.lowdraglib.syncdata.payload.PrimitiveTypedPayload;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public abstract class ReadonlyAccessor implements IAccessor {

    private byte defaultType = -1;

    @Override
    public byte getDefaultType() {
        return defaultType;
    }

    @Override
    public void setDefaultType(byte defaultType) {
        this.defaultType = defaultType;
    }

    public abstract ITypedPayload<?> readFromReadonlyField(AccessorOp op, Object obj);

    public abstract void writeToReadonlyField(AccessorOp op, Object obj, ITypedPayload<?> payload);

    @Override
    public boolean isManaged() {
        return false;
    }

    @Override
    public ITypedPayload<?> readField(AccessorOp op, IRef field) {
        var obj = field.readRaw();
        if (field instanceof ReadOnlyManagedRef managedRef) {
            if (obj == null) {
                return PrimitiveTypedPayload.NullPayload.ofNull();
            } else {
                var tag = new CompoundTag();
                tag.m_128365_("uid", managedRef.getReadOnlyField().serializeUid(obj));

                var payloadTag = new CompoundTag();
                var payload = readFromReadonlyField(op, obj);
                payloadTag.m_128344_("t", payload.getType());
                var data = payload.serializeNBT();
                if (data != null) {
                    payloadTag.m_128365_("d", data);
                }
                tag.m_128365_("payload", payloadTag);
                return NbtTagPayload.of(tag);
            }
        } else if (obj == null) {
            throw new IllegalArgumentException("readonly field %s has a null reference".formatted(field.getKey()));
        }
        return readFromReadonlyField(op, obj);
    }

    @Override
    public void writeField(AccessorOp op, IRef field, ITypedPayload<?> payload) {
        var obj = field.readRaw();
        if (field instanceof ReadOnlyManagedRef managedRef) {
            var readOnlyField = managedRef.getReadOnlyField();
            if(payload instanceof PrimitiveTypedPayload<?> primitive && primitive.isNull()) {
                readOnlyField.set(null);
            } else if (payload instanceof NbtTagPayload nbtTagPayload && nbtTagPayload.getPayload() instanceof CompoundTag tag) {
                var uid = tag.m_128469_("uid");
                if (obj == null || !readOnlyField.serializeUid(obj).equals(uid)) { // need to update obj
                    obj = managedRef.getReadOnlyField().deserializeUid(uid);
                    readOnlyField.set(obj);
                }
                var payloadTag = tag.m_128469_("payload");
                byte id = payloadTag.m_128445_("t");
                var p = TypedPayloadRegistries.create(id);
                p.deserializeNBT(payloadTag.m_128423_("d"));
                writeToReadonlyField(op, obj, p);
            }
            return;
        } else if (obj == null) {
            throw new IllegalArgumentException("readonly field %s has a null reference".formatted(field));
        }
        writeToReadonlyField(op, obj, payload);
    }

}
