package com.lowdragmc.lowdraglib.syncdata.accessor;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.Platform;
import com.lowdragmc.lowdraglib.syncdata.AccessorOp;
import com.lowdragmc.lowdraglib.syncdata.payload.ITypedPayload;
import com.lowdragmc.lowdraglib.syncdata.payload.NbtTagPayload;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;

public class RecipeAccessor extends CustomObjectAccessor<Recipe> {

    public RecipeAccessor() {
        super(Recipe.class, true);
    }

    @Override
    public ITypedPayload<?> serialize(AccessorOp op, Recipe value) {
        var type = BuiltInRegistries.f_256990_.m_7981_(value.m_6671_());
        var id = value.m_6423_();
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("type", type == null ? "null" : type.toString());
        tag.m_128359_("id", id.toString());
        return NbtTagPayload.of(tag);
    }

    @Override
    public Recipe deserialize(AccessorOp op, ITypedPayload<?> payload) {
        if (payload instanceof NbtTagPayload nbtTagPayload && nbtTagPayload.getPayload() instanceof CompoundTag tag) {
            var type = BuiltInRegistries.f_256990_.m_7745_(new ResourceLocation(tag.m_128461_("type")));
            var id = new ResourceLocation(tag.m_128461_("id"));
            if (type != null) {
                RecipeManager recipeManager;
                if (LDLib.isRemote()) {
                    recipeManager = Minecraft.m_91087_().m_91403_().m_105141_();
                } else {
                    recipeManager = Platform.getMinecraftServer().m_129894_();
                }
                for (Recipe<?> recipe : recipeManager.m_44051_()) {
                    if (recipe.m_6671_() == type && recipe.m_6423_().equals(id)) {
                        return recipe;
                    }
                }
            }
        }
        return null;
    }
}
