package com.lowdragmc.lowdraglib.syncdata.payload;

import com.lowdragmc.lowdraglib.syncdata.TypedPayloadRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

import java.util.Objects;

public abstract class ObjectTypedPayload<T> implements ITypedPayload<T> {

    protected T payload;

    protected ObjectTypedPayload() {
    }

    public ITypedPayload<T> setPayload(T payload) {
        this.payload = payload;
        return this;
    }

    @Override
    public byte getType() {
        return TypedPayloadRegistries.getId(getClass());
    }

    @Override
    public T getPayload() {
        return payload;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }


    @Override
    public void writePayload(FriendlyByteBuf buf) {
        var nbt = serializeNBT();
        if (nbt instanceof CompoundTag) {
            buf.writeBoolean(true);
            buf.m_130079_((CompoundTag) nbt);
        } else {
            buf.writeBoolean(false);
            CompoundTag root = new CompoundTag();
            if (nbt != null) {
                root.m_128365_("d", nbt);
            }
            buf.m_130079_(root);
        }
    }

    @Override
    public void readPayload(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            var nbt = buf.m_130260_();
            deserializeNBT(nbt);
        } else {
            var root = buf.m_130260_();
            Objects.requireNonNull(root);
            var nbt = root.m_128423_("d");
            deserializeNBT(nbt);
        }
    }

}
