package com.lowdragmc.lowdraglib.test.ui;

import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegisterClient;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.SceneEditorWidget;
import com.lowdragmc.lowdraglib.gui.editor.ui.sceneeditor.sceneobject.utils.BlockModelObject;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import lombok.NoArgsConstructor;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import org.joml.Quaternionf;
import org.joml.Vector3f;

import java.util.List;

@LDLRegisterClient(name="scene_object", group = "ui_test")
@NoArgsConstructor
public class TestSceneObject implements IUITest {
    @Override
    public ModularUI createUI(IUIHolder holder, Player entityPlayer) {
        var mc = Minecraft.m_91087_();
        var sceneWidget = new SceneEditorWidget(0, 0,
                mc.m_91268_().m_85445_(),
                mc.m_91268_().m_85446_(),
                mc.f_91073_);
        var playerPos = entityPlayer.m_20097_();
        sceneWidget.useCacheBuffer();
        sceneWidget.setRenderedCore(List.of(
                playerPos,
                playerPos.m_7494_(),
                playerPos.m_7495_(),
                playerPos.m_122029_(),
                playerPos.m_122024_(),
                playerPos.m_122012_(),
                playerPos.m_122019_()
        ));

        var testModel = new BlockModelObject();
        testModel.transform().position(new Vector3f(playerPos.m_7494_().m_123341_(), playerPos.m_7494_().m_123342_() + 1, playerPos.m_7494_().m_123343_()));
        testModel.transform().rotation(new Quaternionf().identity().rotationXYZ(30, 23, 75));
        sceneWidget.addSceneObject(testModel);
        sceneWidget.setTransformGizmoTarget(testModel.transform());

//        var sizeBox = new SizeBoxObject();
//        sizeBox.transform().position(new Vector3f(playerPos.below().getX(), playerPos.below().getY() + 1, playerPos.below().getZ()));
//        sceneWidget.addSceneObject(sizeBox);

        return IUITest.super.createUI(holder, entityPlayer)
                .widget(sceneWidget);
    }
}
