package com.lowdragmc.lowdraglib.utils;

import com.lowdragmc.lowdraglib.utils.virtual.VirtualChunk;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LightChunk;
import net.minecraft.world.level.lighting.LevelLightEngine;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import java.util.HashMap;
import java.util.function.BooleanSupplier;

public class DummyChunkSource extends ChunkSource {

    private final DummyWorld world;
    public final HashMap<Long, VirtualChunk> chunks = new HashMap<>();

    public DummyChunkSource(DummyWorld world) {
        this.world = world;
    }

    @Override
    public void m_201698_(BooleanSupplier p_202162_, boolean p_202163_) {

    }

    @Override
    public LightChunk m_6196_(int x, int z) {
        return getChunk(x, z);
    }

    @Nullable
    @Override
    public ChunkAccess m_7587_(int pChunkX, int pChunkZ, ChunkStatus pRequiredStatus, boolean pLoad) {
        return getChunk(pChunkX, pChunkZ);
    }

    public ChunkAccess getChunk(int x, int z) {
        long pos = ChunkPos.m_45589_(x, z);

        return chunks.computeIfAbsent(pos, $ -> new VirtualChunk(world, x, z));
    }

    @Override
    @Nonnull
    public String m_6754_() {
        return "Dummy";
    }

    @Override
    public int m_8482_() {
        return 0;
    }

    @Override
    @Nonnull
    public LevelLightEngine m_7827_() {
        return world.m_5518_();
    }

    @Override
    @Nonnull
    public BlockGetter m_7653_() {
        return world;
    }

}
