package com.lowdragmc.lowdraglib.utils;

import com.google.common.base.Suppliers;
import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.client.scene.ParticleManager;
import com.lowdragmc.lowdraglib.core.mixins.accessor.ParticleEngineAccessor;
import com.lowdragmc.lowdraglib.utils.virtual.WrappedClientWorld;
import lombok.Getter;
import lombok.Setter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.*;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.ticks.LevelTickAccess;

import javax.annotation.Nonnull;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;

/**
 * Author: KilaBash
 * Date: 2022/04/26
 * Description:
 */
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DummyWorld extends Level {

    protected DummyChunkSource chunkProvider = new DummyChunkSource(this);
    private final BiomeManager biomeManager;
    public WeakReference<Level> level;
    protected final LevelLightEngine lighter;
    private final BlockPos.MutableBlockPos scratch = new BlockPos.MutableBlockPos();
    @Getter
    private Supplier<ClientLevel> asClientWorld = Suppliers.memoize(() -> WrappedClientWorld.of(this));


    public DummyWorld(Level level) {
        super((WritableLevelData) level.m_6106_(), level.m_46472_(), level.m_9598_(), level.m_204156_(), level::m_46473_,
                true, false, 0, 0);
        this.level = new WeakReference<>(level);
        this.lighter = new LevelLightEngine(chunkProvider, true, false);
        this.biomeManager = new BiomeManager(this, 0);
    }

    @NotNull
    public Level getLevel() {
        Level level = this.level.get();
        if (level == null) {
            level = Minecraft.m_91087_().f_91073_;
            this.level = new WeakReference<>(level);
        }
        assert level != null;
        return level;
    }

    @Override
    public boolean m_6933_(BlockPos pPos, BlockState pState, int pFlags, int pRecursionLeft) {
        return false;
    }

    @Override
    public void m_151523_(BlockEntity pBlockEntity) {
    }

    @Override
    public BlockState m_8055_(BlockPos pPos) {
        return Blocks.f_50016_.m_49966_();
    }

    @Override
    public void m_6263_(@Nullable Player pPlayer,
                          double pX, double pY, double pZ, SoundEvent pSound,
                          SoundSource pCategory, float pVolume, float pPitch) {

    }

    @Override
    public void m_6269_(@Nullable Player pPlayer,
                          Entity pEntity, SoundEvent pEvent,
                          SoundSource pCategory, float pVolume, float pPitch) {

    }

    @Override
    public String m_46464_() {
        return "";
    }

    @Nullable
    @Override
    public BlockEntity m_7702_(BlockPos pPos) {
        return null;
    }

    @Override
    public float m_7717_(Direction direction, boolean b) {
        return switch (direction) {
            case DOWN, UP -> 0.9F;
            case NORTH, SOUTH -> 0.8F;
            case WEST, EAST -> 0.6F;
        };
    }

    @Override
    public LevelLightEngine m_5518_() {
        if (LDLib.isClient()) {
            return Minecraft.m_91087_().f_91073_.m_5518_();
        }
        return null;
    }

    @Override
    public Holder<Biome> m_204166_(BlockPos pPos) {
        return super.m_204166_(pPos.m_121955_(Vec3i.f_123288_));
    }

    @Override
    public int m_45517_(LightLayer pLightType, BlockPos pBlockPos) {
        return 15;
    }

    @Override
    public int m_45524_(@Nonnull BlockPos pos, int p_226659_2_) {
        return 15;
    }

    @Override
    public boolean m_45527_(@Nonnull BlockPos pos) {
        return true;
    }

    @Override
    public void m_7260_(BlockPos pos, BlockState oldState, BlockState newState, int flags) {

    }

    @Override
    public Holder<Biome> m_203675_(int pX, int pY, int pZ) {
        return getLevel().m_203675_(pX, pY, pZ);
    }

    @Override
    public Holder<Biome> m_203495_(int pX, int pY, int pZ) {
        return getLevel().m_203495_(pX, pY, pZ);
    }

    @Override
    public BiomeManager m_7062_() {
        return this.biomeManager;
    }

    @Override
    public RegistryAccess m_9598_() {
        return getLevel().m_9598_();
    }

    @Override
    public FeatureFlagSet m_246046_() {
        return getLevel().m_246046_();
    }

    @Override
    public LevelTickAccess<Block> m_183326_() {
        return getLevel().m_183326_();
    }

    @Override
    public LevelTickAccess<Fluid> m_183324_() {
        return getLevel().m_183324_();
    }

    @Override
    public RecipeManager m_7465_() {
        return getLevel().m_7465_();
    }

    @Override
    public int m_7354_() {
        return getLevel().m_7354_();
    }

    @Override
    public Scoreboard m_6188_() {
        return getLevel().m_6188_();
    }

    @Override
    public Entity m_6815_(int id) {
        return null;
    }

    @Override
    public MapItemSavedData m_7489_(String mapName) {
        return null;
    }

    @Override
    public void m_142325_(String pMapId, MapItemSavedData pData) {

    }

    @Override
    public void m_6801_(int breakerId, BlockPos pos, int progress) {

    }

    @Override
    protected LevelEntityGetter<Entity> m_142646_() {
        return new LevelEntityGetter<>() {
            @Nullable
            @Override
            public Entity m_142597_(int id) {
                return null;
            }

            @Nullable
            @Override
            public Entity m_142694_(UUID uuid) {
                return null;
            }

            @Override
            public Iterable<Entity> m_142273_() {
                return Collections.emptyList();
            }

            @Override
            public <U extends Entity> void m_142690_(EntityTypeTest<Entity, U> test, AbortableIterationConsumer<U> consumer) {

            }

            @Override
            public void m_142232_(AABB boundingBox, Consumer<Entity> consumer) {

            }

            @Override
            public <U extends Entity> void m_142137_(EntityTypeTest<Entity, U> test, AABB bounds, AbortableIterationConsumer<U> consumer) {

            }
        };
    }

    @Override
    public boolean m_46749_(BlockPos p_195588_1_) {
        return true;
    }

    @Override
    public ChunkSource m_7726_() {
        return chunkProvider;
    }

    @Override
    public void m_5898_(@Nullable Player pPlayer, int pType, BlockPos pPos, int pData) {

    }

    @Override
    public void m_214171_(GameEvent event, Vec3 position, GameEvent.Context context) {

    }

    @Override
    public void m_142346_(@Nullable Entity pEntity, GameEvent pEvent, BlockPos pPos) {

    }

    @Override
    public List<? extends Player> m_6907_() {
        return Collections.emptyList();
    }

    @Override
    public FluidState m_6425_(BlockPos pPos) {
        return Fluids.f_76191_.m_76145_();
    }

    @Override
    public void m_262808_(@Nullable Player player, double x, double y, double z, Holder<SoundEvent> sound, SoundSource source, float volume, float pitch, long seed) {

    }

    @Override
    public void m_214150_(@Nullable Player player, double x, double y, double z, SoundEvent soundEvent, SoundSource soundSource, float volume, float pitch, long seed) {

    }

    @Override
    public void m_213890_(@Nullable Player player, Entity entity, Holder<SoundEvent> sound, SoundSource category, float volume, float pitch, long seed) {

    }

    @Override
    public void m_7106_(ParticleOptions particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        if (particleManager != null) {
            var p = ((ParticleEngineAccessor)Minecraft.m_91087_().f_91061_).invokeMakeParticle(particleData, x, y, z, xSpeed, ySpeed, zSpeed);
            if (p != null) {
                particleManager.addParticle(p);
            }
        }
    }

    @Override
    public void m_6493_(ParticleOptions particleData, boolean forceAlwaysRender, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        m_7106_(particleData, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    @Override
    public void m_7107_(ParticleOptions particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        m_7106_(particleData, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    @Override
    public void m_6485_(ParticleOptions particleData, boolean ignoreRange, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        m_6493_(particleData, ignoreRange, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    @Environment(EnvType.CLIENT)
    @Getter @Setter
    private ParticleManager particleManager;

    public BlockState getBlockState(int x, int y, int z) {
        return m_8055_(scratch.m_122178_(x, y, z));
    }
}
