package com.lowdragmc.lowdraglib.utils;

import dev.architectury.injectables.annotations.ExpectPlatform;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.*;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import java.util.function.Supplier;
import java.util.stream.Stream;

/**
 * Author: KilaBash
 * Date: 2022/04/21
 * Description:
 */
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FacadeBlockAndTintGetter implements BlockAndTintGetter {
    public final BlockAndTintGetter parent;
    public final BlockPos pos;
    public final BlockState state;
    public final BlockEntity tile;

    public FacadeBlockAndTintGetter(BlockAndTintGetter parent, BlockPos pos, BlockState state, @Nullable BlockEntity tile) {
        this.parent = parent;
        this.pos = pos;
        this.state = state;
        this.tile = tile;
    }


    @Override
    public float m_7717_(Direction pDirection, boolean pIsShade) {
        return parent.m_7717_(pDirection, pIsShade);
    }

    @Override
    public LevelLightEngine m_5518_() {
        return parent.m_5518_();
    }

    @Override
    public int m_6171_(BlockPos pBlockPos, ColorResolver pColorResolver) {
        return parent.m_6171_(pBlockPos, pColorResolver);
    }

    @Override
    public int m_45517_(LightLayer pLightType, BlockPos pBlockPos) {
        return parent.m_45517_(pLightType, pBlockPos);
    }

    @Override
    public int m_45524_(BlockPos pBlockPos, int pAmount) {
        return parent.m_45524_(pBlockPos, pAmount);
    }

    @Override
    public boolean m_45527_(BlockPos pBlockPos) {
        return parent.m_45527_(pBlockPos);
    }

    @Nullable
    @Override
    public BlockEntity m_7702_(BlockPos pPos) {
        return pPos.equals(pos) ? tile : parent.m_7702_(pPos);
    }

    @Override
    public BlockState m_8055_(BlockPos pPos) {
        return pPos.equals(pos) ? state : parent.m_8055_(pPos);

    }

    @Override
    public FluidState m_6425_(BlockPos pPos) {
        return parent.m_6425_(pPos);
    }

    @Override
    public int m_7146_(BlockPos pPos) {
        return parent.m_7146_(pPos);
    }

    @Override
    public int m_7469_() {
        return parent.m_7469_();
    }

    @Override
    public int m_141928_() {
        return parent.m_141928_();
    }

    @Override
    public int m_141937_() {
        return parent.m_141937_();
    }

    @Override
    public int m_151558_() {
        return parent.m_151558_();
    }

    @Override
    public int m_151559_() {
        return parent.m_151559_();
    }

    @Override
    public int m_151560_() {
        return parent.m_151560_();
    }

    @Override
    public int m_151561_() {
        return parent.m_151561_();
    }

    @Override
    public boolean m_151570_(BlockPos pPos) {
        return parent.m_151570_(pPos);
    }

    @Override
    public boolean m_151562_(int pY) {
        return parent.m_151562_(pY);
    }

    @Override
    public int m_151564_(int pY) {
        return parent.m_151564_(pY);
    }

    @Override
    public int m_151566_(int pSectionIndex) {
        return parent.m_151566_(pSectionIndex);
    }

    @Override
    public int m_151568_(int pSectionIndex) {
        return parent.m_151568_(pSectionIndex);
    }

    @Override
    public Stream<BlockState> m_45556_(AABB pArea) {
        return parent.m_45556_(pArea);
    }

    @Override
    public BlockHitResult m_151353_(ClipBlockStateContext pContext) {
        return parent.m_151353_(pContext);
    }

    @Override
    public BlockHitResult m_45547_(ClipContext pContext) {
        return parent.m_45547_(pContext);
    }

    @Nullable
    @Override
    public BlockHitResult m_45558_(Vec3 pStartVec, Vec3 pEndVec, BlockPos pPos, VoxelShape pShape, BlockState pState) {
        return parent.m_45558_(pStartVec, pEndVec, pPos, pShape, pState);
    }

    @Override
    public double m_45564_(VoxelShape pShape, Supplier<VoxelShape> p_242402_2_) {
        return parent.m_45564_(pShape, p_242402_2_);
    }

    @Override
    public double m_45573_(BlockPos pPos) {
        return parent.m_45573_(pPos);
    }

//    @Override
//    public @Nullable BlockEntity getExistingBlockEntity(BlockPos pos) {
//        return pos.equals(this.pos) ? tile : BlockAndTintGetter.super.getExistingBlockEntity(pos);
//    }

    @ExpectPlatform
    public static BlockState getAppearance(BlockState state, BlockAndTintGetter renderView, BlockPos pos, Direction side, @Nullable BlockState sourceState, @Nullable BlockPos sourcePos) {
        throw new AssertionError();
    }
}
