package com.lowdragmc.lowdraglib.utils;

import com.lowdragmc.lowdraglib.client.scene.ParticleManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

/**
 * Author: KilaBash
 * Date: 2022/04/26
 * Description:
 */
@Environment(EnvType.CLIENT)
public class FacadeBlockWorld extends DummyWorld {

    public final BlockPos pos;
    public final BlockState state;
    public final BlockEntity tile;

    public FacadeBlockWorld(Level world, BlockPos pos, BlockState state, BlockEntity tile) {
        super(world);
        this.pos = pos;
        this.state = state;
        this.tile = tile;
    }

    @Nullable
    @Override
    public BlockEntity m_7702_(@Nonnull BlockPos pPos) {
        return pPos.equals(pos) ? tile : getLevel().m_7702_(pPos);
    }

    @Override
    @ParametersAreNonnullByDefault
    @Nonnull
    public BlockState m_8055_(BlockPos pPos) {
        return pPos.equals(pos) ? state : getLevel().m_8055_(pPos);
    }

    @Override
    @Nonnull
    public LevelLightEngine m_5518_() {
        return getLevel().m_5518_();
    }

    @Override
    public int m_45517_(@Nonnull LightLayer lightType, @Nonnull BlockPos pos) {
        return getLevel().m_45517_(lightType, pos);
    }

    @Override
    public int m_6171_(@Nonnull BlockPos blockPos, @Nonnull ColorResolver colorResolver) {
        return getLevel().m_6171_(blockPos, colorResolver);
    }

    @Override
    public boolean m_45527_(@Nonnull BlockPos pos) {
        return getLevel().m_45527_(pos);
    }

    @Nonnull
    @Override
    public DimensionType m_6042_() {
        return getLevel().m_6042_();
    }

    @Override
    public boolean m_46859_(@Nonnull BlockPos pPos) {
        return !pPos.equals(pos) && getLevel().m_46859_(pPos);
    }

    @Nonnull
    @Override
    @Environment(EnvType.CLIENT)
    public Holder<Biome> m_204166_(@Nonnull BlockPos pos) {
        return getLevel().m_204166_(pos);
    }

    @Override
    @Environment(EnvType.CLIENT)
    public void setParticleManager(@Nonnull ParticleManager particleManager) {
        super.setParticleManager(particleManager);
        if (getLevel() instanceof DummyWorld dummyWorld) {
            dummyWorld.setParticleManager(particleManager);
        }
    }

    @Nullable
    @Override
    @Environment(EnvType.CLIENT)
    public ParticleManager getParticleManager() {
        ParticleManager particleManager = super.getParticleManager();
        if (particleManager == null && getLevel() instanceof DummyWorld dummyWorld) {
            return dummyWorld.getParticleManager();
        }
        return particleManager;
    }
}
