package com.lowdragmc.lowdraglib.utils;

import net.minecraft.world.item.ItemStack;

import java.util.Arrays;

public final class ItemStackKey {

    private final ItemStack[] itemStack;
    private final int hashCode;

    public ItemStackKey(ItemStack... itemStack) {
        this.itemStack = Arrays.stream(itemStack).map(item -> {
            ItemStack copied = item.m_41777_();
            copied.m_41764_(1);
            return copied;
        }).toArray(ItemStack[]::new);
        this.hashCode = makeHashCode();
    }

    public ItemStack[] getItemStack() {
        return itemStack;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof ItemStackKey that)) return false;
        if (that.itemStack.length == this.itemStack.length) {
            for (ItemStack a : that.itemStack) {
                if (Arrays.stream(this.itemStack).noneMatch(b -> ItemStack.m_41728_(a, b))) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return hashCode;
    }

    private int makeHashCode() {
        int itemsHash = 0;
        for (ItemStack stack : itemStack) {
            itemsHash += stack.m_41720_().hashCode();
            itemsHash += stack.m_41773_();
            itemsHash += stack.m_41783_() == null ? 0 : stack.m_41783_().hashCode();
        }
        return itemsHash;
    }

    @Override
    public String toString() {
        return Arrays.toString(itemStack);
    }
}
