package com.lowdragmc.lowdraglib.utils;

import com.google.gson.*;
import net.minecraft.nbt.*;

import java.util.Set;

/**
 * @author KilaBash
 * @date 2022/10/22
 * @implNote NBTToJsonConverter
 * @copyright <a href="https://github.com/MineMaarten/PneumaticCraft/blob/master/src/pneumaticCraft/common/util/NBTToJsonConverter.java">PneumaticCraft</a>
 */
public class NBTToJsonConverter {

    public static JsonElement getObject(Tag tag) {
        JsonElement jsonRoot;
        if (tag instanceof CompoundTag compoundTag) {
            Set<String> keys = compoundTag.m_128431_();
            jsonRoot = new JsonObject();
            for (String key : keys) {
                Tag nbt = compoundTag.m_128423_(key);
                ((JsonObject)jsonRoot).add(key, getObject(nbt));
            }
        } else if (tag instanceof NumericTag numericTag) {
            jsonRoot = new JsonPrimitive(numericTag.m_8103_());
        } else if (tag instanceof StringTag) {
            jsonRoot = new JsonPrimitive(tag.m_7916_());
        } else {
            JsonArray array;
            if (tag instanceof ListTag tagList) {
                array = new JsonArray();
                for (Tag value : tagList) {
                    array.add(getObject(value));
                }
                jsonRoot = array;
            } else if (tag instanceof IntArrayTag intArray) {
                array = new JsonArray();
                for (int i : intArray.m_128648_()) {
                    array.add(new JsonPrimitive(i));
                }
                jsonRoot = array;
            } else if (tag instanceof ByteArrayTag intArray) {
                array = new JsonArray();
                for (byte i : intArray.m_128227_()) {
                    array.add(new JsonPrimitive(i));
                }
                jsonRoot = array;
            } else if (tag instanceof LongArrayTag intArray) {
                array = new JsonArray();
                for (long i : intArray.m_128851_()) {
                    array.add(new JsonPrimitive(i));
                }
                jsonRoot = array;
            } else {
                throw new JsonParseException("NBT to JSON converter doesn't support the nbt tag: " + tag.m_7060_() + ", tag: " + tag);
            }
        }

        return jsonRoot;
    }
}
