package com.lowdragmc.lowdraglib.utils;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

import java.util.function.Predicate;

/**
 * @author KilaBash
 * @date 2023/2/17
 * @implNote RaytraceHelper, copied from create.
 */
public class RayTraceHelper {
    public static BlockHitResult rayTraceRange(Level worldIn, Player playerIn, double range) {
        Vec3 origin = getTraceOrigin(playerIn);
        Vec3 target = getTraceTarget(playerIn, range, origin);
        ClipContext context = new ClipContext(origin, target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, playerIn);
        return worldIn.m_45547_(context);
    }

    public static PredicateTraceResult rayTraceUntil(Player playerIn, double range, Predicate<BlockPos> predicate) {
        Vec3 origin = getTraceOrigin(playerIn);
        Vec3 target = getTraceTarget(playerIn, range, origin);
        return rayTraceUntil(origin, target, predicate);
    }

    public static Vec3 getTraceTarget(Player playerIn, double range, Vec3 origin) {
        float f = playerIn.m_146909_();
        float f1 = playerIn.m_146908_();
        float f2 = Mth.m_14089_(-f1 * 0.017453292F - (float) Math.PI);
        float f3 = Mth.m_14031_(-f1 * 0.017453292F - (float) Math.PI);
        float f4 = -Mth.m_14089_(-f * 0.017453292F);
        float f5 = Mth.m_14031_(-f * 0.017453292F);
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        return origin.m_82520_((double) f6 * range, (double) f5 * range, (double) f7 * range);
    }

    public static Vec3 getTraceOrigin(Player playerIn) {
        double d0 = playerIn.m_20185_();
        double d1 = playerIn.m_20186_() + (double) playerIn.m_20192_();
        double d2 = playerIn.m_20189_();
        return new Vec3(d0, d1, d2);
    }

    public static PredicateTraceResult rayTraceUntil(Vec3 start, Vec3 end, Predicate<BlockPos> predicate) {
        if (Double.isNaN(start.f_82479_) || Double.isNaN(start.f_82480_) || Double.isNaN(start.f_82481_))
            return null;
        if (Double.isNaN(end.f_82479_) || Double.isNaN(end.f_82480_) || Double.isNaN(end.f_82481_))
            return null;

        int dx = Mth.m_14107_(end.f_82479_);
        int dy = Mth.m_14107_(end.f_82480_);
        int dz = Mth.m_14107_(end.f_82481_);
        int x = Mth.m_14107_(start.f_82479_);
        int y = Mth.m_14107_(start.f_82480_);
        int z = Mth.m_14107_(start.f_82481_);

        BlockPos.MutableBlockPos currentPos = new BlockPos(x, y, z).m_122032_();

        if (predicate.test(currentPos))
            return new PredicateTraceResult(currentPos.m_7949_(), Direction.m_122372_(dx - x, dy - y, dz - z));

        int remainingDistance = 200;

        while (remainingDistance-- >= 0) {
            if (Double.isNaN(start.f_82479_) || Double.isNaN(start.f_82480_) || Double.isNaN(start.f_82481_)) {
                return null;
            }

            if (x == dx && y == dy && z == dz) {
                return new PredicateTraceResult();
            }

            boolean flag2 = true;
            boolean flag = true;
            boolean flag1 = true;
            double d0 = 999.0D;
            double d1 = 999.0D;
            double d2 = 999.0D;

            if (dx > x) {
                d0 = (double) x + 1.0D;
            } else if (dx < x) {
                d0 = (double) x + 0.0D;
            } else {
                flag2 = false;
            }

            if (dy > y) {
                d1 = (double) y + 1.0D;
            } else if (dy < y) {
                d1 = (double) y + 0.0D;
            } else {
                flag = false;
            }

            if (dz > z) {
                d2 = (double) z + 1.0D;
            } else if (dz < z) {
                d2 = (double) z + 0.0D;
            } else {
                flag1 = false;
            }

            double d3 = 999.0D;
            double d4 = 999.0D;
            double d5 = 999.0D;
            double d6 = end.f_82479_ - start.f_82479_;
            double d7 = end.f_82480_ - start.f_82480_;
            double d8 = end.f_82481_ - start.f_82481_;

            if (flag2) {
                d3 = (d0 - start.f_82479_) / d6;
            }

            if (flag) {
                d4 = (d1 - start.f_82480_) / d7;
            }

            if (flag1) {
                d5 = (d2 - start.f_82481_) / d8;
            }

            if (d3 == -0.0D) {
                d3 = -1.0E-4D;
            }

            if (d4 == -0.0D) {
                d4 = -1.0E-4D;
            }

            if (d5 == -0.0D) {
                d5 = -1.0E-4D;
            }

            Direction enumfacing;

            if (d3 < d4 && d3 < d5) {
                enumfacing = dx > x ? Direction.WEST : Direction.EAST;
                start = new Vec3(d0, start.f_82480_ + d7 * d3, start.f_82481_ + d8 * d3);
            } else if (d4 < d5) {
                enumfacing = dy > y ? Direction.DOWN : Direction.UP;
                start = new Vec3(start.f_82479_ + d6 * d4, d1, start.f_82481_ + d8 * d4);
            } else {
                enumfacing = dz > z ? Direction.NORTH : Direction.SOUTH;
                start = new Vec3(start.f_82479_ + d6 * d5, start.f_82480_ + d7 * d5, d2);
            }

            x = Mth.m_14107_(start.f_82479_) - (enumfacing == Direction.EAST ? 1 : 0);
            y = Mth.m_14107_(start.f_82480_) - (enumfacing == Direction.UP ? 1 : 0);
            z = Mth.m_14107_(start.f_82481_) - (enumfacing == Direction.SOUTH ? 1 : 0);
            currentPos.m_122178_(x, y, z);

            if (predicate.test(currentPos))
                return new PredicateTraceResult(currentPos.m_7949_(), enumfacing);
        }

        return new PredicateTraceResult();
    }

    public static class PredicateTraceResult {
        private BlockPos pos;
        private Direction facing;

        public PredicateTraceResult(BlockPos pos, Direction facing) {
            this.pos = pos;
            this.facing = facing;
        }

        public PredicateTraceResult() {
            // missed, no result
        }

        public Direction getFacing() {
            return facing;
        }

        public BlockPos getPos() {
            return pos;
        }

        public boolean missed() {
            return this.pos == null;
        }
    }
}
