package com.lowdragmc.lowdraglib.utils;

import com.lowdragmc.lowdraglib.LDLib;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;

import javax.annotation.Nonnull;
import java.net.URL;

/**
 * @author KilaBash
 * @date 2023/2/20
 * @implNote ResourceHelper
 */
public class ResourceHelper {
    public static boolean isResourceExistRaw(ResourceLocation rs) {
        URL url = ResourceHelper.class.getResource(String.format("/assets/%s/%s", rs.m_135827_(), rs.m_135815_()));
        return url != null;
    }

    public static boolean isResourceExist(ResourceLocation rs) {
        if (LDLib.isClient()) {
            return Minecraft.m_91087_().m_91098_().m_213713_(rs).isPresent();
        } else {
            return false;
        }
    }

    public static boolean isTextureExist(@Nonnull ResourceLocation location) {
        var textureLocation = new ResourceLocation(location.m_135827_(), "textures/%s.png".formatted(location.m_135815_()));
        return isResourceExist(textureLocation) || isResourceExistRaw(textureLocation);
    }

    public static boolean isModelExist(@Nonnull ResourceLocation location) {
        var modelLocation = new ResourceLocation(location.m_135827_(), "models/%s.json".formatted(location.m_135815_()));
        return isResourceExist(modelLocation) || isResourceExistRaw(modelLocation);
    }

}
