package com.lowdragmc.lowdraglib.utils;


import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Vector3f;

/**
 * @author KilaBash
 * @date 2022/6/17
 * @implNote ShapeUtils
 */
public class ShapeUtils {

    public static AABB rotate(AABB AABB, Direction facing) {
        switch (facing) {
            case SOUTH -> {
                return rotate(AABB, new Vector3f(0, 1, 0), 180);
            }
            case EAST -> {
                return rotate(AABB, new Vector3f(0, 1, 0), -90);
            }
            case WEST -> {
                return rotate(AABB, new Vector3f(0, 1, 0), 90);
            }
            case UP -> {
                return rotate(AABB, new Vector3f(1, 0, 0), 90);
            }
            case DOWN -> {
                return rotate(AABB, new Vector3f(1, 0, 0), -90);
            }
        }
        return AABB;
    }

    public static AABB rotate(AABB AABB, Vector3f axis, double degree) {
        Vector3f min = new Vector3f((float) AABB.f_82288_, (float) AABB.f_82289_, (float) AABB.f_82290_).sub(0.5f, 0.5f, 0.5f);
        Vector3f max = new Vector3f((float) AABB.f_82291_, (float) AABB.f_82292_, (float) AABB.f_82293_).sub(0.5f, 0.5f, 0.5f);
        float radians = (float) Math.toRadians(degree);
        min.rotateAxis(radians, axis.x, axis.y, axis.z);
        max.rotateAxis(radians, axis.x, axis.y, axis.z);
        min.add(0.5f, 0.5f, 0.5f);
        max.add(0.5f, 0.5f, 0.5f);
        return new AABB(min.x, min.y, min.z, max.x, max.y, max.z);
    }

    public static VoxelShape rotate(VoxelShape shape, Direction facing) {
        return shape.m_83299_().stream().map(AABB -> Shapes.m_83064_(rotate(AABB, facing))).reduce(Shapes.m_83040_(), Shapes::m_83110_);
    }

    public static VoxelShape rotate(VoxelShape shape, Vector3f axis, double degree) {
        return shape.m_83299_().stream().map(AABB -> Shapes.m_83064_(rotate(AABB, axis, degree))).reduce(Shapes.m_83040_(), Shapes::m_83110_);
    }
}
