package com.lowdragmc.lowdraglib.utils.curve;

import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import com.lowdragmc.lowdraglib.utils.Interpolations;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.phys.Vec2;

/**
 * @author KilaBash
 * @date 2022/6/17
 * @implNote ExplicitCubicBezierCurve2
 */
public class ExplicitCubicBezierCurve2 extends Curve<Vec2> implements ITagSerializable<ListTag> {
    public Vec2 p0, c0, c1, p1;

    public ExplicitCubicBezierCurve2(Vec2 start, Vec2 control1, Vec2 control2, Vec2 end) {
        this.p0 = start;
        this.c0 = control1;
        this.c1 = control2;
        this.p1 = end;
    }

    public ExplicitCubicBezierCurve2(ListTag list) {
        deserializeNBT(list);
    }

    @Override
    public Vec2 getPoint(float t) {
        if (c0.f_82470_ == p0.f_82470_) {
            return new Vec2(p0.f_82470_ + t * (p1.f_82470_ - p0.f_82470_), c0.f_82471_ > p0.f_82471_ ? p0.f_82471_ : p1.f_82471_);
        }
        if (c1.f_82470_ == p1.f_82470_) {
            return new Vec2(p0.f_82470_ + t * (p1.f_82470_ - p0.f_82470_), c1.f_82471_ > p1.f_82471_ ? p1.f_82471_ : p0.f_82471_);
        }
        return new Vec2(
                p0.f_82470_ + t * (p1.f_82470_ - p0.f_82470_),
                (float) Interpolations.CubicBezier(t, p0.f_82471_, c0.f_82471_, c1.f_82471_, p1.f_82471_)
        );
    }

    @Override
    public ListTag serializeNBT() {
        var list = new ListTag();
        list.add(FloatTag.m_128566_(p0.f_82470_));
        list.add(FloatTag.m_128566_(p0.f_82471_));

        list.add(FloatTag.m_128566_(c0.f_82470_));
        list.add(FloatTag.m_128566_(c0.f_82471_));

        list.add(FloatTag.m_128566_(c1.f_82470_));
        list.add(FloatTag.m_128566_(c1.f_82471_));

        list.add(FloatTag.m_128566_(p1.f_82470_));
        list.add(FloatTag.m_128566_(p1.f_82471_));
        return list;
    }

    @Override
    public void deserializeNBT(ListTag list) {
        p0 = new Vec2(list.m_128775_(0), list.m_128775_(1));
        c0 = new Vec2(list.m_128775_(2), list.m_128775_(3));
        c1 = new Vec2(list.m_128775_(4), list.m_128775_(5));
        p1 = new Vec2(list.m_128775_(6), list.m_128775_(7));
    }
}
