package com.lowdragmc.lowdraglib.utils.virtual;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import java.util.List;

@Environment(EnvType.CLIENT)
@SuppressWarnings("deprecation")
@ParametersAreNonnullByDefault
public class WrappedClientWorld extends ClientLevel {
    private static final Minecraft mc = Minecraft.m_91087_();
    protected Level world;

    private WrappedClientWorld(Level world) {
        super(mc.m_91403_(), mc.f_91073_.m_6106_(), world.m_46472_(), world.m_204156_(),
                12, mc.f_91073_.m_194186_(), world.m_46658_(),
                mc.f_91060_, world.m_46659_(), -1);
        this.world = world;
    }

    public static WrappedClientWorld of(Level world) {
        return new WrappedClientWorld(world);
    }

    @Override
    public boolean m_46805_(BlockPos pos) {
        return world.m_46805_(pos);
    }

    @Override
    public boolean m_46749_(BlockPos pos) {
        return world.m_46749_(pos);
    }

    @Override
    public BlockState m_8055_(BlockPos pos) {
        return world.m_8055_(pos);
    }

    // FIXME: blockstate#getCollisionShape with WrappedClientWorld gives unreliable
    // data (maybe)

    @Override
    public int m_45517_(LightLayer type, BlockPos pos) {
        return world.m_45517_(type, pos);
    }

    @Override
    public int m_7146_(BlockPos pos) {
        return world.m_7146_(pos);
    }

    @Override
    public FluidState m_6425_(BlockPos pos) {
        return world.m_6425_(pos);
    }

    @Nullable
    @Override
    public <T extends LivingEntity> T m_45982_(List<? extends T> p_217361_1_, TargetingConditions p_217361_2_,
                                                       @Nullable LivingEntity p_217361_3_, double p_217361_4_, double p_217361_6_, double p_217361_8_) {
        return world.m_45982_(p_217361_1_, p_217361_2_, p_217361_3_, p_217361_4_, p_217361_6_, p_217361_8_);
    }

    @Override
    public int m_6171_(BlockPos p_225525_1_, ColorResolver p_225525_2_) {
        return world.m_6171_(p_225525_1_, p_225525_2_);
    }

    @Override
    public void m_7106_(ParticleOptions p_195594_1_, double p_195594_2_, double p_195594_4_, double p_195594_6_,
                            double p_195594_8_, double p_195594_10_, double p_195594_12_) {
        world.m_7106_(p_195594_1_, p_195594_2_, p_195594_4_, p_195594_6_, p_195594_8_, p_195594_10_, p_195594_12_);
    }

    @Override
    public void m_6493_(ParticleOptions p_195590_1_, boolean p_195590_2_, double p_195590_3_, double p_195590_5_,
                            double p_195590_7_, double p_195590_9_, double p_195590_11_, double p_195590_13_) {
        world.m_6493_(p_195590_1_, p_195590_2_, p_195590_3_, p_195590_5_, p_195590_7_, p_195590_9_, p_195590_11_,
                p_195590_13_);
    }

    @Override
    public void m_7107_(ParticleOptions p_195589_1_, double p_195589_2_, double p_195589_4_,
                                         double p_195589_6_, double p_195589_8_, double p_195589_10_, double p_195589_12_) {
        world.m_7107_(p_195589_1_, p_195589_2_, p_195589_4_, p_195589_6_, p_195589_8_, p_195589_10_,
                p_195589_12_);
    }

    @Override
    public void m_6485_(ParticleOptions p_217404_1_, boolean p_217404_2_, double p_217404_3_,
                                         double p_217404_5_, double p_217404_7_, double p_217404_9_, double p_217404_11_, double p_217404_13_) {
        world.m_6485_(p_217404_1_, p_217404_2_, p_217404_3_, p_217404_5_, p_217404_7_, p_217404_9_,
                p_217404_11_, p_217404_13_);
    }

    @Override
    public void m_7785_(double p_184134_1_, double p_184134_3_, double p_184134_5_, SoundEvent p_184134_7_,
                               SoundSource p_184134_8_, float p_184134_9_, float p_184134_10_, boolean p_184134_11_) {
        world.m_7785_(p_184134_1_, p_184134_3_, p_184134_5_, p_184134_7_, p_184134_8_, p_184134_9_, p_184134_10_,
                p_184134_11_);
    }

    @Override
    public void m_6263_(@Nullable Player p_184148_1_, double p_184148_2_, double p_184148_4_, double p_184148_6_,
                          SoundEvent p_184148_8_, SoundSource p_184148_9_, float p_184148_10_, float p_184148_11_) {
        world.m_6263_(p_184148_1_, p_184148_2_, p_184148_4_, p_184148_6_, p_184148_8_, p_184148_9_, p_184148_10_,
                p_184148_11_);
    }

    @Nullable
    @Override
    public BlockEntity m_7702_(BlockPos p_175625_1_) {
        return world.m_7702_(p_175625_1_);
    }

    public Level getWrappedWorld() {
        return world;
    }
}
