/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.ritchiesprojectilelib.effects.screen_shake;

import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import rbasamoyai.ritchiesprojectilelib.RitchiesProjectileLib;
import rbasamoyai.ritchiesprojectilelib.effects.screen_shake.ModScreenShakeHandler;
import rbasamoyai.ritchiesprojectilelib.effects.screen_shake.ScreenShakeContext;
import rbasamoyai.ritchiesprojectilelib.effects.screen_shake.ScreenShakeEffect;

public class RPLScreenShakeHandlerClient {
    private static final Map<class_2960, ModScreenShakeHandler> HANDLERS = new Object2ReferenceOpenHashMap();
    public static final class_2960 DEFAULT_HANDLER_ID = RitchiesProjectileLib.resource("shake_handler");
    public static final ModScreenShakeHandler.Impl DEFAULT_HANDLER = RPLScreenShakeHandlerClient.registerModScreenShakeHandler(DEFAULT_HANDLER_ID, new ModScreenShakeHandler.Impl());

    public static <T extends ModScreenShakeHandler> T registerModScreenShakeHandler(class_2960 id, T handler) {
        if (HANDLERS.containsKey(id)) {
            throw new IllegalStateException("Ritchie's Projectile Library screen shake handler already has registered handler entry '" + String.valueOf(id) + "'");
        }
        HANDLERS.put(id, handler);
        return handler;
    }

    public static void tick(class_310 minecraft) {
        if (minecraft.method_1493()) {
            return;
        }
        for (ModScreenShakeHandler handler : HANDLERS.values()) {
            handler.tick(minecraft);
        }
    }

    public static ScreenShakeContext getScreenShake(float partialTicks) {
        ScreenShakeContext context = new ScreenShakeContext(partialTicks);
        for (ModScreenShakeHandler handler : HANDLERS.values()) {
            handler.applyEffects(context);
        }
        return context;
    }

    public static void addShakeEffect(ScreenShakeEffect effect) {
        DEFAULT_HANDLER.addEffect(effect);
    }

    public static void addShakeEffect(class_2960 modHandlerId, ScreenShakeEffect effect) {
        if (!HANDLERS.containsKey(modHandlerId)) {
            return;
        }
        HANDLERS.get(modHandlerId).addEffect(effect);
    }

    public static void onPlayerLogOut(class_1657 player) {
        for (ModScreenShakeHandler handler : HANDLERS.values()) {
            handler.clearEffects();
        }
    }
}

