/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.ritchiesprojectilelib.projectile_burst;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1675;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5712;
import rbasamoyai.ritchiesprojectilelib.network.ClientboundSyncBurstSubProjectilesPacket;
import rbasamoyai.ritchiesprojectilelib.network.RPLNetwork;
import rbasamoyai.ritchiesprojectilelib.projectile_burst.ProjectileBurstClipContext;

public abstract class ProjectileBurst
extends class_1676 {
    protected int age = 0;
    protected final List<SubProjectile> subProjectiles = new LinkedList<SubProjectile>();

    protected ProjectileBurst(class_1299<? extends ProjectileBurst> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void method_5652(class_2487 tag) {
        class_2499 list = new class_2499();
        for (SubProjectile subProjectile : this.subProjectiles) {
            list.add((Object)subProjectile.toTag());
        }
        tag.method_10566("SubProjectiles", (class_2520)list);
        tag.method_10569("Age", this.age);
    }

    protected void method_5749(class_2487 tag) {
        this.subProjectiles.clear();
        class_2499 list = tag.method_10554("SubProjectiles", 10);
        int sz = list.size();
        for (int i = 0; i < sz; ++i) {
            this.subProjectiles.add(SubProjectile.fromTag(list.method_10602(i)));
        }
        this.age = tag.method_10550("Age");
    }

    protected void method_5693() {
    }

    protected void syncAllDataToServer() {
        RPLNetwork.sendToClientTracking(new ClientboundSyncBurstSubProjectilesPacket(this.method_5628(), this.age, new LinkedList<SubProjectile>(this.subProjectiles)), (class_1297)this);
    }

    public void updateClientData(int age, List<SubProjectile> subProjectiles) {
        this.age = age;
        this.subProjectiles.clear();
        this.subProjectiles.addAll(subProjectiles);
    }

    public void method_5773() {
        if (!this.method_37908().field_9236 && this.field_6012 % 10 == 1) {
            this.syncAllDataToServer();
        }
        Iterator<SubProjectile> iter = this.subProjectiles.iterator();
        while (iter.hasNext()) {
            SubProjectile subProjectile = iter.next();
            class_239 result = this.clipAndDamage(subProjectile);
            if (result.method_17783() != class_239.class_240.field_1333) {
                this.onSubProjectileHit(result, subProjectile);
                iter.remove();
                continue;
            }
            subProjectile.displacement[0] = subProjectile.displacement[0] + subProjectile.velocity[0];
            subProjectile.displacement[1] = subProjectile.displacement[1] + subProjectile.velocity[1];
            subProjectile.displacement[2] = subProjectile.displacement[2] + subProjectile.velocity[2];
            this.applyForces(subProjectile.velocity, subProjectile.displacement);
        }
        super.method_5773();
        if (++this.age >= this.getLifetime()) {
            this.method_31472();
        }
    }

    protected abstract int getLifetime();

    protected abstract void applyForces(double[] var1, double[] var2);

    protected class_239 clipAndDamage(SubProjectile info) {
        class_243 vel = new class_243(info.velocity[0], info.velocity[1], info.velocity[2]);
        class_243 start = new class_243(info.displacement[0] + this.method_23317(), info.displacement[1] + this.method_23318(), info.displacement[2] + this.method_23321());
        class_243 end = start.method_1019(vel);
        double halfHeight = this.getSubProjectileHeight() / 2.0;
        double halfWidth = this.getSubProjectileWidth() / 2.0;
        class_3965 hitResult = this.method_37908().method_17742((class_3959)new ProjectileBurstClipContext(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this, start.field_1351 - halfHeight));
        if (hitResult.method_17783() != class_239.class_240.field_1333) {
            end = hitResult.method_17784();
        }
        class_238 aabb = new class_238(start.field_1352 - halfWidth, start.field_1351 - halfHeight, start.field_1350 - halfWidth, start.field_1352 + halfWidth, start.field_1351 + halfHeight, start.field_1350 + halfWidth);
        class_3966 hitResult2 = class_1675.method_37226((class_1937)this.method_37908(), (class_1297)this, (class_243)start, (class_243)end, (class_238)aabb.method_18804(vel).method_1014(1.0), this::method_26958, (float)((float)halfWidth));
        if (hitResult2 != null) {
            hitResult = hitResult2;
        }
        return hitResult;
    }

    public void addSubProjectile(double dispX, double dispY, double dispZ, double velX, double velY, double velZ) {
        this.subProjectiles.add(new SubProjectile(new double[]{dispX, dispY, dispZ}, new double[]{velX, velY, velZ}));
    }

    public int getSubProjectileCount() {
        return this.subProjectiles.size();
    }

    public List<SubProjectile> getSubProjectiles() {
        return this.subProjectiles;
    }

    public abstract double getSubProjectileWidth();

    public abstract double getSubProjectileHeight();

    public boolean method_5863() {
        return false;
    }

    protected boolean method_26958(class_1297 target) {
        return super.method_26958(target) && !target.field_5960;
    }

    protected void onSubProjectileHit(class_239 result, SubProjectile subProjectile) {
        class_239.class_240 type = result.method_17783();
        if (type == class_239.class_240.field_1331) {
            this.onSubProjectileHitEntity((class_3966)result, subProjectile);
        } else if (type == class_239.class_240.field_1332) {
            this.onSubProjectileHitBlock((class_3965)result, subProjectile);
        }
        if (type != class_239.class_240.field_1333) {
            this.method_37908().method_43275((class_1297)this, class_5712.field_28162, new class_243(subProjectile.displacement[0] + this.method_23317(), subProjectile.displacement[1] + this.method_23318(), subProjectile.displacement[2] + this.method_23321()));
        }
    }

    protected void onSubProjectileHitEntity(class_3966 result, SubProjectile subProjectile) {
    }

    protected void onSubProjectileHitBlock(class_3965 result, SubProjectile subProjectile) {
        class_2680 blockState = this.method_37908().method_8320(result.method_17777());
        blockState.method_26175(this.method_37908(), blockState, result, (class_1676)this);
    }

    public record SubProjectile(double[] displacement, double[] velocity) {
        public class_2487 toTag() {
            class_2487 tag = new class_2487();
            class_2499 posTag = new class_2499();
            posTag.add((Object)class_2489.method_23241((double)this.displacement[0]));
            posTag.add((Object)class_2489.method_23241((double)this.displacement[1]));
            posTag.add((Object)class_2489.method_23241((double)this.displacement[2]));
            tag.method_10566("Pos", (class_2520)posTag);
            class_2499 velTag = new class_2499();
            velTag.add((Object)class_2489.method_23241((double)this.velocity[0]));
            velTag.add((Object)class_2489.method_23241((double)this.velocity[1]));
            velTag.add((Object)class_2489.method_23241((double)this.velocity[2]));
            tag.method_10566("Vel", (class_2520)velTag);
            return tag;
        }

        public static SubProjectile fromTag(class_2487 tag) {
            class_2499 posTag = tag.method_10554("Pos", 6);
            class_2499 velTag = tag.method_10554("Vel", 6);
            return new SubProjectile(new double[]{posTag.method_10611(0), posTag.method_10611(1), posTag.method_10611(2)}, new double[]{velTag.method_10611(0), velTag.method_10611(1), velTag.method_10611(2)});
        }
    }
}

