/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.ritchiesprojectilelib.chunkloading;

import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Map;
import net.minecraft.class_18;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2839;
import net.minecraft.class_3215;
import net.minecraft.class_3218;
import net.minecraft.class_3230;
import net.minecraft.class_4076;
import org.jetbrains.annotations.NotNull;
import rbasamoyai.ritchiesprojectilelib.config.RPLConfigs;

public class ChunkManager
extends class_18 {
    private final LongOpenHashSet chunks;
    private final LongArrayFIFOQueue queue = new LongArrayFIFOQueue();
    private final LongOpenHashSet inQueue;
    private final Long2IntOpenHashMap loaded = new Long2IntOpenHashMap();

    public ChunkManager() {
        this(new LongOpenHashSet());
    }

    public ChunkManager(LongOpenHashSet chunks) {
        this.chunks = chunks;
        this.inQueue = new LongOpenHashSet((LongCollection)this.chunks);
        LongIterator longIterator = this.chunks.iterator();
        while (longIterator.hasNext()) {
            long packedPos = (Long)longIterator.next();
            this.queue.enqueue(packedPos);
        }
    }

    public static ChunkManager load(class_2487 tag) {
        long[] arr = tag.method_10565("LoadedChunks");
        LongOpenHashSet chunks = new LongOpenHashSet(arr);
        return new ChunkManager(chunks);
    }

    @NotNull
    public class_2487 method_75(class_2487 tag) {
        tag.method_10564("LoadedChunks", this.chunks.toLongArray());
        return tag;
    }

    @Deprecated
    public void queueForceLoad(class_1923 pos) {
        long packedPos = pos.method_8324();
        if (this.inQueue.add(packedPos)) {
            this.queue.enqueue(packedPos);
            this.chunks.add(packedPos);
            this.method_80();
        }
    }

    public void tick(class_3218 level) {
        long packedPos;
        LongSet vanillaForcedChunks = level.method_17984();
        int MAX_SIZE = (Integer)RPLConfigs.server().maxChunksForceLoaded.get();
        if (MAX_SIZE <= 0) {
            MAX_SIZE = Integer.MAX_VALUE;
        }
        int MAX_CHUNKS_PROCESSED = (Integer)RPLConfigs.server().maxChunksLoadedEachTick.get();
        int DEFAULT_AGE = (Integer)RPLConfigs.server().projectileChunkAge.get();
        int ENTITY_LOAD_TIMEOUT_AGE = -((Integer)RPLConfigs.server().entityLoadTimeout.get()).intValue() - 1;
        LongOpenHashSet expired = new LongOpenHashSet();
        for (Map.Entry entry : this.loaded.long2IntEntrySet()) {
            long packedPos2 = (Long)entry.getKey();
            int age = (Integer)entry.getValue();
            if (age <= -1) {
                class_1923 cpos = new class_1923(packedPos2);
                class_2338 bpos = new class_2338(class_4076.method_18688((int)cpos.field_9181), 0, class_4076.method_18688((int)cpos.field_9180));
                if (level.method_37118(bpos)) {
                    age = DEFAULT_AGE;
                }
            }
            int newAge = age - 1;
            entry.setValue(newAge);
            if (newAge != 0 && newAge > ENTITY_LOAD_TIMEOUT_AGE) continue;
            expired.add(packedPos2);
        }
        int freeSlots = Math.max(0, MAX_SIZE - this.loaded.size());
        int pollCount = Math.min(MAX_CHUNKS_PROCESSED, freeSlots + expired.size());
        pollCount = Math.min(pollCount, this.queue.size());
        for (int i = 0; i < pollCount && !this.queue.isEmpty(); ++i) {
            packedPos = this.queue.dequeueLong();
            this.inQueue.remove(packedPos);
            class_1923 chunkPos = new class_1923(packedPos);
            if (this.loaded.containsKey(packedPos) && this.loaded.get(packedPos) > -1) {
                this.loaded.put(packedPos, DEFAULT_AGE);
                expired.remove(packedPos);
                continue;
            }
            if (!vanillaForcedChunks.contains(packedPos) && ChunkManager.loadChunkNoGenerate(level, chunkPos)) {
                this.loaded.put(packedPos, -1);
                level.method_14178().method_12124(chunkPos, true);
                continue;
            }
            this.chunks.remove(packedPos);
        }
        LongIterator longIterator = expired.iterator();
        while (longIterator.hasNext()) {
            packedPos = (Long)longIterator.next();
            level.method_14178().method_12124(new class_1923(packedPos), false);
            this.loaded.remove(packedPos);
            if (this.inQueue.contains(packedPos)) continue;
            this.chunks.remove(packedPos);
        }
        this.loaded.trim();
        this.inQueue.trim();
        this.queue.trim();
        this.chunks.trim();
        this.method_80();
    }

    private static boolean loadChunkNoGenerate(class_3218 level, class_1923 cpos) {
        class_3215 source = level.method_14178();
        class_2818 immediate = source.method_21730(cpos.field_9181, cpos.field_9180);
        if (immediate != null) {
            return true;
        }
        class_2791 access = source.method_12121(cpos.field_9181, cpos.field_9180, class_2806.field_12798, true);
        if (access instanceof class_2839) {
            source.method_17300(class_3230.field_14032, cpos, -11, (Object)cpos);
            access = source.method_12121(cpos.field_9181, cpos.field_9180, class_2806.field_12803, true);
        }
        return access instanceof class_2818;
    }
}

