/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.ritchiesprojectilelib.effects.screen_shake;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_243;
import net.minecraft.class_310;
import rbasamoyai.ritchiesprojectilelib.effects.screen_shake.ScreenShakeContext;
import rbasamoyai.ritchiesprojectilelib.effects.screen_shake.ScreenShakeEffect;

public interface ModScreenShakeHandler {
    public void tick(class_310 var1);

    public void addEffect(ScreenShakeEffect var1);

    public void clearEffects();

    public void applyEffects(ScreenShakeContext var1);

    public static class Impl
    implements ModScreenShakeHandler {
        protected final Set<ScreenShakeEffect> delayedShakes = new LinkedHashSet<ScreenShakeEffect>();
        protected class_243 velocity = class_243.field_1353;
        protected class_243 acceleration = class_243.field_1353;
        protected class_243 displacement = class_243.field_1353;
        protected final Random random = new Random();

        @Override
        public void tick(class_310 minecraft) {
            Iterator<ScreenShakeEffect> iter = this.delayedShakes.iterator();
            while (iter.hasNext()) {
                ScreenShakeEffect effect = iter.next();
                if (!effect.tick()) continue;
                this.immediatelyAddEffect(effect);
                iter.remove();
            }
            int iterations = 10;
            double dt = 1.0 / (double)iterations;
            double restitution = Math.max(0.005, this.getRestitution());
            double drag = Math.max(0.005, this.getDrag());
            for (int i = 0; i < iterations; ++i) {
                class_243 newRotationDisplacement = this.displacement.method_1019(this.velocity.method_1021(dt)).method_1019(this.acceleration.method_1021(0.5 * dt * dt));
                class_243 newAccel = this.displacement.method_1021(-restitution).method_1019(this.velocity.method_1021(-drag));
                class_243 newVel = this.velocity.method_1019(this.acceleration.method_1019(newAccel).method_1021(0.5 * dt));
                this.displacement = newRotationDisplacement;
                this.velocity = newVel;
                this.acceleration = newAccel;
                this.applyConstraints();
            }
            if (this.displacement.method_1027() < 1.0E-4 && this.velocity.method_1027() < 1.0E-4 && this.acceleration.method_1027() < 1.0E-4) {
                this.clearEffects();
            }
        }

        @Override
        public void applyEffects(ScreenShakeContext context) {
            float partialTicks = context.partialTicks();
            class_243 currentDisp = this.displacement.method_1019(this.velocity.method_1021((double)partialTicks)).method_1019(this.acceleration.method_1021((double)(partialTicks * partialTicks) * 0.5));
            context.setDeltaYaw(context.getDeltaYaw() + (float)currentDisp.field_1352);
            context.setDeltaPitch(context.getDeltaPitch() + (float)currentDisp.field_1351);
            context.setDeltaRoll(context.getDeltaRoll() + (float)currentDisp.field_1350);
        }

        @Override
        public void addEffect(ScreenShakeEffect effect) {
            if (effect.duration <= 0) {
                this.immediatelyAddEffect(effect);
            } else {
                this.delayedShakes.add(effect);
            }
        }

        protected void immediatelyAddEffect(ScreenShakeEffect effect) {
            ScreenShakeEffect modified = this.modifyScreenShake(effect);
            double dy = (double)modified.yawMagnitude * (this.random.nextDouble() - this.random.nextDouble()) * 0.5;
            double dp = (double)modified.pitchMagnitude * (this.random.nextDouble() - this.random.nextDouble()) * 0.5;
            double dr = (double)modified.rollMagnitude * (this.random.nextDouble() - this.random.nextDouble()) * 0.5;
            this.velocity = this.velocity.method_1031(dy, dp, dr);
        }

        @Override
        public void clearEffects() {
            this.displacement = class_243.field_1353;
            this.velocity = class_243.field_1353;
            this.acceleration = class_243.field_1353;
        }

        protected ScreenShakeEffect modifyScreenShake(ScreenShakeEffect effect) {
            return effect;
        }

        protected double getRestitution() {
            return 0.1;
        }

        protected double getDrag() {
            return 0.2;
        }

        protected void applyConstraints() {
        }
    }
}

