/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.ritchiesprojectilelib.chunkloading;

import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.saveddata.SavedData;
import org.jetbrains.annotations.NotNull;
import rbasamoyai.ritchiesprojectilelib.config.RPLConfigs;

public class ChunkManager
extends SavedData {
    private final LongOpenHashSet chunks;
    private final LongArrayFIFOQueue queue = new LongArrayFIFOQueue();
    private final LongOpenHashSet inQueue;
    private final Long2IntOpenHashMap loaded = new Long2IntOpenHashMap();

    public ChunkManager() {
        this(new LongOpenHashSet());
    }

    public static SavedData.Factory<ChunkManager> factory() {
        return new SavedData.Factory(ChunkManager::new, (tag, provider) -> ChunkManager.load((CompoundTag)tag, (HolderLookup.Provider)provider), DataFixTypes.SAVED_DATA_FORCED_CHUNKS);
    }

    public ChunkManager(LongOpenHashSet chunks) {
        this.chunks = chunks;
        this.inQueue = new LongOpenHashSet((LongCollection)this.chunks);
        LongIterator longIterator = this.chunks.iterator();
        while (longIterator.hasNext()) {
            long packedPos = (Long)longIterator.next();
            this.queue.enqueue(packedPos);
        }
    }

    public static ChunkManager load(CompoundTag tag, HolderLookup.Provider registries) {
        long[] arr = tag.getLongArray("LoadedChunks");
        LongOpenHashSet chunks = new LongOpenHashSet(arr);
        return new ChunkManager(chunks);
    }

    @NotNull
    public CompoundTag save(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putLongArray("LoadedChunks", this.chunks.toLongArray());
        return tag;
    }

    @Deprecated
    public void queueForceLoad(ChunkPos pos) {
        long packedPos = pos.toLong();
        if (this.inQueue.add(packedPos)) {
            this.queue.enqueue(packedPos);
            this.chunks.add(packedPos);
            this.setDirty();
        }
    }

    public void tick(ServerLevel level) {
        long packedPos;
        LongSet vanillaForcedChunks = level.getForcedChunks();
        int MAX_SIZE = (Integer)RPLConfigs.server().maxChunksForceLoaded.get();
        if (MAX_SIZE <= 0) {
            MAX_SIZE = Integer.MAX_VALUE;
        }
        int MAX_CHUNKS_PROCESSED = (Integer)RPLConfigs.server().maxChunksLoadedEachTick.get();
        int DEFAULT_AGE = (Integer)RPLConfigs.server().projectileChunkAge.get();
        int ENTITY_LOAD_TIMEOUT_AGE = -((Integer)RPLConfigs.server().entityLoadTimeout.get()).intValue() - 1;
        LongOpenHashSet expired = new LongOpenHashSet();
        for (Map.Entry entry : this.loaded.long2IntEntrySet()) {
            long packedPos2 = (Long)entry.getKey();
            int age = (Integer)entry.getValue();
            if (age <= -1) {
                ChunkPos cpos = new ChunkPos(packedPos2);
                BlockPos bpos = new BlockPos(SectionPos.sectionToBlockCoord((int)cpos.x), 0, SectionPos.sectionToBlockCoord((int)cpos.z));
                if (level.isPositionEntityTicking(bpos)) {
                    age = DEFAULT_AGE;
                }
            }
            int newAge = age - 1;
            entry.setValue(newAge);
            if (newAge != 0 && newAge > ENTITY_LOAD_TIMEOUT_AGE) continue;
            expired.add(packedPos2);
        }
        int freeSlots = Math.max(0, MAX_SIZE - this.loaded.size());
        int pollCount = Math.min(MAX_CHUNKS_PROCESSED, freeSlots + expired.size());
        pollCount = Math.min(pollCount, this.queue.size());
        for (int i = 0; i < pollCount && !this.queue.isEmpty(); ++i) {
            packedPos = this.queue.dequeueLong();
            this.inQueue.remove(packedPos);
            ChunkPos chunkPos = new ChunkPos(packedPos);
            if (this.loaded.containsKey(packedPos) && this.loaded.get(packedPos) > -1) {
                this.loaded.put(packedPos, DEFAULT_AGE);
                expired.remove(packedPos);
                continue;
            }
            if (!vanillaForcedChunks.contains(packedPos) && ChunkManager.loadChunkNoGenerate(level, chunkPos)) {
                this.loaded.put(packedPos, -1);
                level.getChunkSource().updateChunkForced(chunkPos, true);
                continue;
            }
            this.chunks.remove(packedPos);
        }
        LongIterator longIterator = expired.iterator();
        while (longIterator.hasNext()) {
            packedPos = (Long)longIterator.next();
            level.getChunkSource().updateChunkForced(new ChunkPos(packedPos), false);
            this.loaded.remove(packedPos);
            if (this.inQueue.contains(packedPos)) continue;
            this.chunks.remove(packedPos);
        }
        this.loaded.trim();
        this.inQueue.trim();
        this.queue.trim();
        this.chunks.trim();
        this.setDirty();
    }

    private static boolean loadChunkNoGenerate(ServerLevel level, ChunkPos cpos) {
        ServerChunkCache source = level.getChunkSource();
        LevelChunk immediate = source.getChunkNow(cpos.x, cpos.z);
        if (immediate != null) {
            return true;
        }
        ChunkAccess access = source.getChunk(cpos.x, cpos.z, ChunkStatus.EMPTY, true);
        if (access instanceof ProtoChunk) {
            source.removeRegionTicket(TicketType.UNKNOWN, cpos, -11, (Object)cpos);
            access = source.getChunk(cpos.x, cpos.z, ChunkStatus.FULL, true);
        }
        return access instanceof LevelChunk;
    }
}

