/*
 * Decompiled with CFR 0.152.
 */
package org.notritik.rxmenu;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.notritik.rxmenu.commands.MenuCommandHandler;
import org.notritik.rxmenu.commands.RxMenuCommand;
import org.notritik.rxmenu.commands.RxMenuTabCompleter;
import org.notritik.rxmenu.config.MenuConfig;
import org.notritik.rxmenu.listeners.MenuListener;
import org.notritik.rxmenu.models.Menu;
import org.notritik.rxmenu.utils.Settings;

public final class RxMenu
extends JavaPlugin {
    private static RxMenu instance;
    private MenuConfig menuConfig;
    private Map<UUID, String> editingPlayers;
    private Map<String, PluginCommand> registeredCommands;
    private WatchService watchService;
    private Map<String, Long> lastModifiedTimes;
    private boolean isReloading = false;

    public void onEnable() {
        File menusFolder;
        instance = this;
        this.editingPlayers = new HashMap<UUID, String>();
        this.registeredCommands = new HashMap<String, PluginCommand>();
        this.lastModifiedTimes = new HashMap<String, Long>();
        this.saveDefaultConfig();
        Settings.load(this);
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        if (!(menusFolder = new File(this.getDataFolder(), "menus")).exists()) {
            menusFolder.mkdirs();
        }
        this.menuConfig = new MenuConfig(this);
        this.menuConfig.loadMenus();
        this.getCommand("rxmenu").setExecutor((CommandExecutor)new RxMenuCommand(this));
        this.getCommand("rxmenu").setTabCompleter((TabCompleter)new RxMenuTabCompleter(this));
        this.getServer().getPluginManager().registerEvents((Listener)new MenuListener(this), (Plugin)this);
        this.registerMenuCommands();
        this.startFileWatcher();
        this.getLogger().info("RxMenu has been enabled!");
    }

    public void onDisable() {
        this.stopFileWatcher();
        this.unregisterMenuCommands();
        if (this.menuConfig != null) {
            this.menuConfig.saveMenus();
        }
        this.getLogger().info("RxMenu has been disabled!");
    }

    private void startFileWatcher() {
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
            final Path menuFolder = new File(this.getDataFolder(), "menus").toPath();
            menuFolder.register(this.watchService, StandardWatchEventKinds.ENTRY_MODIFY);
            new BukkitRunnable(){

                public void run() {
                    try {
                        WatchKey key = RxMenu.this.watchService.poll(100L, TimeUnit.MILLISECONDS);
                        if (key != null) {
                            for (WatchEvent<?> event : key.pollEvents()) {
                                Path changedFile;
                                if (event.kind() != StandardWatchEventKinds.ENTRY_MODIFY || !(changedFile = menuFolder.resolve((Path)event.context())).toString().endsWith(".yml")) continue;
                                RxMenu.this.handleFileChange(changedFile.toFile());
                            }
                            key.reset();
                        }
                    }
                    catch (Exception e) {
                        RxMenu.this.getLogger().warning("Error in file watcher: " + e.getMessage());
                    }
                }
            }.runTaskTimerAsynchronously((Plugin)this, 20L, 20L);
        }
        catch (Exception e) {
            this.getLogger().warning("Failed to start file watcher: " + e.getMessage());
        }
    }

    private void handleFileChange(File file) {
        if (this.isReloading) {
            return;
        }
        long lastModified = file.lastModified();
        final String fileName = file.getName();
        Long lastTime = this.lastModifiedTimes.get(fileName);
        if (lastTime != null && lastTime >= lastModified - 1000L) {
            return;
        }
        this.lastModifiedTimes.put(fileName, lastModified);
        new BukkitRunnable(){

            public void run() {
                try {
                    RxMenu.this.isReloading = true;
                    RxMenu.this.menuConfig.loadMenus();
                    RxMenu.this.registerMenuCommands();
                    RxMenu.this.getLogger().info("Reloaded menu: " + fileName);
                }
                finally {
                    RxMenu.this.isReloading = false;
                }
            }
        }.runTaskLater((Plugin)this, 10L);
    }

    private void stopFileWatcher() {
        if (this.watchService != null) {
            try {
                this.watchService.close();
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to stop file watcher: " + e.getMessage());
            }
        }
    }

    public static RxMenu getInstance() {
        return instance;
    }

    public MenuConfig getMenuConfig() {
        return this.menuConfig;
    }

    public Map<UUID, String> getEditingPlayers() {
        return this.editingPlayers;
    }

    public void registerMenuCommands() {
        this.unregisterMenuCommands();
        for (Menu menu : this.menuConfig.getMenus().values()) {
            String command = menu.getOpenCommand();
            if (command.isEmpty()) continue;
            try {
                Constructor constructor = PluginCommand.class.getDeclaredConstructor(String.class, Plugin.class);
                constructor.setAccessible(true);
                PluginCommand pluginCommand = (PluginCommand)constructor.newInstance(new Object[]{command, this});
                pluginCommand.setDescription(menu.getCommandDescription());
                pluginCommand.setUsage("/" + command);
                pluginCommand.setAliases(menu.getCommandAliases());
                pluginCommand.setPermission(menu.getCommandPermission());
                pluginCommand.setPermissionMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)menu.getCommandPermissionMessage()));
                pluginCommand.setExecutor((CommandExecutor)new MenuCommandHandler(this, menu.getName()));
                Field bukkitCommandMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
                bukkitCommandMap.setAccessible(true);
                CommandMap commandMap = (CommandMap)bukkitCommandMap.get(Bukkit.getServer());
                commandMap.register(command, (Command)pluginCommand);
                this.registeredCommands.put(command, pluginCommand);
                this.getLogger().info("Registered command /" + command + " for menu " + menu.getName());
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to register command for menu " + menu.getName() + ": " + e.getMessage());
            }
        }
    }

    public void unregisterMenuCommands() {
        if (this.registeredCommands != null) {
            try {
                Field bukkitCommandMap = Bukkit.getServer().getClass().getDeclaredField("commandMap");
                bukkitCommandMap.setAccessible(true);
                CommandMap commandMap = (CommandMap)bukkitCommandMap.get(Bukkit.getServer());
                Field knownCommandsField = commandMap.getClass().getDeclaredField("knownCommands");
                knownCommandsField.setAccessible(true);
                Map knownCommands = (Map)knownCommandsField.get(commandMap);
                for (String command : this.registeredCommands.keySet()) {
                    knownCommands.remove(command);
                    knownCommands.remove("rxmenu:" + command);
                    this.getLogger().info("Unregistered command /" + command);
                }
            }
            catch (Exception e) {
                this.getLogger().warning("Failed to unregister commands: " + e.getMessage());
            }
            this.registeredCommands.clear();
        }
    }
}

