/*
 * Decompiled with CFR 0.152.
 */
package org.notritik.rxmenu.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.notritik.rxmenu.RxMenu;
import org.notritik.rxmenu.models.Menu;
import org.notritik.rxmenu.models.MenuAction;
import org.notritik.rxmenu.models.MenuItem;
import org.notritik.rxmenu.utils.Settings;

public class RxMenuCommand
implements CommandExecutor {
    private final RxMenu plugin;
    private static final String[] COMMANDS = new String[]{"reload", "open", "create", "edit", "delete", "setitem", "setaction", "setname", "setdesc", "settitle", "list", "info", "rename", "sethead"};

    public RxMenuCommand(RxMenu plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.sendHelp(sender);
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                if (!sender.hasPermission("rxmenu.reload")) {
                    sender.sendMessage(Settings.getNoPermissionMessage());
                    return true;
                }
                this.plugin.getMenuConfig().loadMenus();
                this.plugin.registerMenuCommands();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "RxMenu configuration reloaded!");
                break;
            }
            case "open": {
                if (!(sender instanceof Player)) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be used by players!");
                    return true;
                }
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /rxmenu open <menu>");
                    return true;
                }
                String menuName = args[1];
                Menu menu = this.plugin.getMenuConfig().getMenu(menuName);
                if (menu == null) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Menu not found: " + menuName);
                    return true;
                }
                menu.open((Player)sender);
                break;
            }
            case "create": {
                this.handleCreate(sender, args);
                break;
            }
            case "edit": {
                this.handleEdit(sender, args);
                break;
            }
            case "delete": {
                this.handleDelete(sender, args);
                break;
            }
            case "setaction": {
                this.handleSetAction(sender, args);
                break;
            }
            case "clearaction": {
                this.handleClearAction(sender, args);
                break;
            }
            case "setname": {
                this.handleSetName(sender, args);
                break;
            }
            case "setdesc": {
                this.handleSetDesc(sender, args);
                break;
            }
            case "settitle": {
                this.handleSetTitle(sender, args);
                break;
            }
            case "list": {
                this.handleList(sender);
                break;
            }
            case "info": {
                this.handleInfo(sender, args);
                break;
            }
            case "rename": {
                this.handleRename(sender, args);
                break;
            }
            case "sethead": {
                this.handleSetHead(sender, args);
                break;
            }
            default: {
                this.sendHelp(sender);
            }
        }
        return true;
    }

    private void handleCreate(CommandSender sender, String[] args) {
        Object title;
        int size;
        if (!sender.hasPermission("rxmenu.create")) {
            sender.sendMessage(Settings.getNoPermissionMessage());
            return;
        }
        if (args.length < 3) {
            sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.RED) + "Usage: /rxmenu create <name> <size> [title]");
            sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.GRAY) + "Example: /rxmenu create shop 27 &6Shop Menu");
            sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.GRAY) + "Example: /rxmenu create warps 54 &bServer Warps");
            return;
        }
        String name = args[1].toLowerCase();
        String originalName = args[1];
        try {
            size = Integer.parseInt(args[2]);
            if (size % 9 != 0 || size < 9 || size > 54) {
                sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.RED) + "Size must be 9, 18, 27, 36, 45, or 54!");
                return;
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.RED) + "Size must be a number!");
            return;
        }
        if (this.plugin.getMenuConfig().menuExists(name)) {
            sender.sendMessage(Settings.getMenuExistsMessage());
            return;
        }
        if (args.length > 3) {
            StringBuilder titleBuilder = new StringBuilder();
            for (int i = 3; i < args.length; ++i) {
                titleBuilder.append(args[i]).append(" ");
            }
            title = titleBuilder.toString().trim();
        } else {
            title = "&8" + originalName;
        }
        Menu menu = new Menu(originalName, (String)title, size);
        this.plugin.getMenuConfig().createMenu(name, menu);
        sender.sendMessage(Settings.getMenuCreatedMessage());
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Use /rxmenu edit " + originalName + " to customize your menu!");
    }

    private void handleEdit(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be used by players!");
            return;
        }
        if (!sender.hasPermission("rxmenu.edit")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
            return;
        }
        if (args.length < 2) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /rxmenu edit <menu>");
            return;
        }
        Menu menu = this.plugin.getMenuConfig().getMenu(args[1]);
        if (menu == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Menu not found!");
            return;
        }
        Player player = (Player)sender;
        this.plugin.getEditingPlayers().put(player.getUniqueId(), menu.getName());
        menu.open(player);
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Now editing menu: " + menu.getName());
    }

    private void handleDelete(CommandSender sender, String[] args) {
        if (!sender.hasPermission("rxmenu.delete")) {
            sender.sendMessage(Settings.getNoPermissionMessage());
            return;
        }
        if (args.length < 2) {
            sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.RED) + "Usage: /rxmenu delete <menu>");
            return;
        }
        if (!this.plugin.getMenuConfig().menuExists(args[1])) {
            sender.sendMessage(Settings.getMenuNotFoundMessage());
            return;
        }
        this.plugin.getMenuConfig().deleteMenu(args[1]);
        sender.sendMessage(Settings.getMenuDeletedMessage());
    }

    private void handleSetAction(CommandSender sender, String[] args) {
        MenuAction menuAction;
        int slot;
        if (!sender.hasPermission("rxmenu.edit")) {
            sender.sendMessage(Settings.getNoPermissionMessage());
            return;
        }
        if (args.length < 4) {
            sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.RED) + "Usage: /rxmenu setaction <menu> <slot> <type> <action>");
            sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.GRAY) + "Types: COMMAND, CONSOLE, MESSAGE");
            return;
        }
        String menuName = args[1];
        Menu menu = this.plugin.getMenuConfig().getMenu(menuName);
        if (menu == null) {
            sender.sendMessage(Settings.getMenuNotFoundMessage());
            return;
        }
        try {
            slot = Integer.parseInt(args[2]);
            if (slot < 0 || slot >= menu.getSize()) {
                sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.RED) + "Invalid slot number! Must be between 0 and " + (menu.getSize() - 1));
                return;
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.RED) + "Slot must be a number!");
            return;
        }
        String type = args[3].toUpperCase();
        if (!Arrays.asList("COMMAND", "CONSOLE", "MESSAGE").contains(type)) {
            sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.RED) + "Invalid action type! Must be: COMMAND, CONSOLE, or MESSAGE");
            return;
        }
        MenuItem item = menu.getItem(slot);
        if (item == null) {
            sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.RED) + "No item in slot " + slot + "! Use /rxmenu setitem first.");
            return;
        }
        StringBuilder actionBuilder = new StringBuilder();
        for (int i = 4; i < args.length; ++i) {
            if (i > 4) {
                actionBuilder.append(" ");
            }
            actionBuilder.append(args[i]);
        }
        Object action = actionBuilder.toString().trim();
        if (((String)action).isEmpty()) {
            sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.RED) + "Action cannot be empty!");
            return;
        }
        switch (type) {
            case "MESSAGE": {
                menuAction = MenuAction.message((String)action);
                sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.GREEN) + "Message set: " + ChatColor.translateAlternateColorCodes((char)'&', (String)action));
                break;
            }
            case "COMMAND": {
                if (!((String)action).startsWith("/")) {
                    action = "/" + (String)action;
                }
                menuAction = MenuAction.command((String)action);
                sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.GREEN) + "Command set: " + (String)action);
                break;
            }
            case "CONSOLE": {
                if (!((String)action).startsWith("/")) {
                    action = "/" + (String)action;
                }
                menuAction = MenuAction.consoleCommand((String)action);
                sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.GREEN) + "Console command set: " + (String)action);
                break;
            }
            default: {
                sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.RED) + "Invalid action type!");
                return;
            }
        }
        item.addAction(menuAction);
        this.plugin.getMenuConfig().saveMenu(menu);
    }

    private void handleClearAction(CommandSender sender, String[] args) {
        int slot;
        if (!sender.hasPermission("rxmenu.edit")) {
            sender.sendMessage(Settings.getNoPermissionMessage());
            return;
        }
        if (args.length < 3) {
            sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.RED) + "Usage: /rxmenu clearaction <menu> <slot>");
            return;
        }
        String menuName = args[1];
        Menu menu = this.plugin.getMenuConfig().getMenu(menuName);
        if (menu == null) {
            sender.sendMessage(Settings.getMenuNotFoundMessage());
            return;
        }
        try {
            slot = Integer.parseInt(args[2]);
            if (slot < 0 || slot >= menu.getSize()) {
                sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.RED) + "Invalid slot number! Must be between 0 and " + (menu.getSize() - 1));
                return;
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.RED) + "Slot must be a number!");
            return;
        }
        MenuItem item = menu.getItem(slot);
        if (item == null) {
            sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.RED) + "No item in slot " + slot + "!");
            return;
        }
        item.clearActions();
        this.plugin.getMenuConfig().saveMenu(menu);
        sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.GREEN) + "All actions cleared from item in slot " + slot + "!");
    }

    private void handleSetName(CommandSender sender, String[] args) {
        int slot;
        if (!sender.hasPermission("rxmenu.edit")) {
            sender.sendMessage(Settings.getNoPermissionMessage());
            return;
        }
        if (args.length < 4) {
            sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.RED) + "Usage: /rxmenu setname <menu> <slot> <name>");
            return;
        }
        Menu menu = this.plugin.getMenuConfig().getMenu(args[1]);
        if (menu == null) {
            sender.sendMessage(Settings.getMenuNotFoundMessage());
            return;
        }
        try {
            slot = Integer.parseInt(args[2]);
            if (slot < 0 || slot >= menu.getSize()) {
                sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.RED) + "Invalid slot number!");
                return;
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.RED) + "Slot must be a number!");
            return;
        }
        MenuItem item = menu.getItem(slot);
        if (item == null) {
            sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.RED) + "No item in that slot!");
            return;
        }
        StringBuilder name = new StringBuilder();
        for (int i = 3; i < args.length; ++i) {
            name.append(args[i]).append(" ");
        }
        String displayName = name.toString().trim();
        item.setName(displayName);
        this.plugin.getMenuConfig().saveMenu(menu);
        sender.sendMessage(Settings.getItemNameChangedMessage());
    }

    private void handleSetDesc(CommandSender sender, String[] args) {
        int line;
        int slot;
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "This command can only be used by players!");
            return;
        }
        Player player = (Player)sender;
        if (!sender.hasPermission("rxmenu.edit")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission to use this command!");
            return;
        }
        if (args.length < 5) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /rxmenu setdesc <menu> <slot> <line> <description>");
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Example: /rxmenu setdesc shop 0 1 &aClick to buy!");
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Example: /rxmenu setdesc shop 0 2 &7Cost: &e100 coins");
            return;
        }
        Menu menu = this.plugin.getMenuConfig().getMenu(args[1]);
        if (menu == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Menu not found: " + args[1]);
            return;
        }
        try {
            slot = Integer.parseInt(args[2]);
            if (slot < 0 || slot >= menu.getSize()) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid slot number!");
                return;
            }
        }
        catch (NumberFormatException e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Slot must be a number!");
            return;
        }
        try {
            line = Integer.parseInt(args[3]);
            if (line < 1) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Line number must be 1 or greater!");
                return;
            }
        }
        catch (NumberFormatException e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Line number must be a number!");
            return;
        }
        MenuItem item = menu.getItem(slot);
        if (item == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "No item in that slot!");
            return;
        }
        List<String> lore = item.getLore();
        if (lore == null) {
            lore = new ArrayList<String>();
        }
        while (lore.size() < line - 1) {
            lore.add("");
        }
        String description = String.join((CharSequence)" ", Arrays.copyOfRange(args, 4, args.length));
        String coloredDesc = ChatColor.translateAlternateColorCodes((char)'&', (String)description);
        if (line <= lore.size()) {
            lore.set(line - 1, coloredDesc);
        } else {
            lore.add(coloredDesc);
        }
        item.setLore(lore);
        this.plugin.getMenuConfig().saveMenu(menu);
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Description set at line " + line + " successfully!");
        menu.updateInventory();
    }

    private void handleSetTitle(CommandSender sender, String[] args) {
        if (!sender.hasPermission("rxmenu.edit")) {
            sender.sendMessage(Settings.getNoPermissionMessage());
            return;
        }
        if (args.length < 3) {
            sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.RED) + "Usage: /rxmenu settitle <menu> <title>");
            sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.GRAY) + "Example: /rxmenu settitle shop &6Shop Menu");
            return;
        }
        Menu menu = this.plugin.getMenuConfig().getMenu(args[1]);
        if (menu == null) {
            sender.sendMessage(Settings.getMenuNotFoundMessage());
            return;
        }
        StringBuilder titleBuilder = new StringBuilder();
        for (int i = 2; i < args.length; ++i) {
            titleBuilder.append(args[i]).append(" ");
        }
        String title = titleBuilder.toString().trim();
        menu.setTitle(title);
        if (menu.getInventory() != null) {
            ArrayList viewers = new ArrayList(menu.getInventory().getViewers());
            for (HumanEntity viewer : viewers) {
                if (!(viewer instanceof Player)) continue;
                menu.open((Player)viewer);
            }
        }
        this.plugin.getMenuConfig().saveMenu(menu);
        sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.GREEN) + "Menu title updated to: " + ChatColor.translateAlternateColorCodes((char)'&', (String)title));
    }

    private void handleList(CommandSender sender) {
        if (!sender.hasPermission("rxmenu.list")) {
            sender.sendMessage(Settings.getNoPermissionMessage());
            return;
        }
        Map<String, Menu> menus = this.plugin.getMenuConfig().getMenus();
        if (menus.isEmpty()) {
            sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.YELLOW) + "No menus found!");
            return;
        }
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "=== Available Menus ===");
        for (Menu menu : menus.values()) {
            sender.sendMessage(String.valueOf(ChatColor.AQUA) + menu.getName() + String.valueOf(ChatColor.GRAY) + ":");
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "  Size: " + String.valueOf(ChatColor.WHITE) + menu.getSize() + " slots");
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "  Title: " + String.valueOf(ChatColor.WHITE) + menu.getTitle());
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "  Items: " + String.valueOf(ChatColor.WHITE) + menu.getItems().size());
            sender.sendMessage("");
        }
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "==================");
    }

    private void handleInfo(CommandSender sender, String[] args) {
        if (!sender.hasPermission("rxmenu.admin")) {
            sender.sendMessage(Settings.getNoPermissionMessage());
            return;
        }
        if (args.length < 2) {
            sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.RED) + "Usage: /rxmenu info <menu>");
            return;
        }
        Menu menu = this.plugin.getMenuConfig().getMenu(args[1]);
        if (menu == null) {
            sender.sendMessage(Settings.getMenuNotFoundMessage());
            return;
        }
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "=== Menu Information ===");
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Name: " + String.valueOf(ChatColor.WHITE) + menu.getName());
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Title: " + String.valueOf(ChatColor.WHITE) + menu.getTitle());
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Size: " + String.valueOf(ChatColor.WHITE) + menu.getSize() + " slots");
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Items: " + String.valueOf(ChatColor.WHITE) + menu.getItems().size());
        if (!menu.getItems().isEmpty()) {
            sender.sendMessage(String.valueOf(ChatColor.GRAY) + "Item Details:");
            menu.getItems().forEach((slot, item) -> {
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "  Slot " + slot + ":");
                sender.sendMessage(String.valueOf(ChatColor.GRAY) + "    Material: " + String.valueOf(ChatColor.WHITE) + String.valueOf(item.getMaterial()));
                sender.sendMessage(String.valueOf(ChatColor.GRAY) + "    Name: " + String.valueOf(ChatColor.WHITE) + item.getName());
                if (!item.getActions().isEmpty()) {
                    sender.sendMessage(String.valueOf(ChatColor.GRAY) + "    Actions:");
                    item.getActions().forEach(action -> sender.sendMessage(String.valueOf(ChatColor.GRAY) + "      - " + String.valueOf(ChatColor.WHITE) + action.getData()));
                }
            });
        }
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "=====================");
    }

    private void handleRename(CommandSender sender, String[] args) {
        if (!sender.hasPermission("rxmenu.edit")) {
            sender.sendMessage(Settings.getNoPermissionMessage());
            return;
        }
        if (args.length < 3) {
            sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.RED) + "Usage: /rxmenu rename <oldname> <newname>");
            return;
        }
        String oldName = args[1];
        String newName = args[2];
        Menu oldMenu = this.plugin.getMenuConfig().getMenu(oldName);
        if (oldMenu == null) {
            sender.sendMessage(Settings.getMenuNotFoundMessage());
            return;
        }
        if (this.plugin.getMenuConfig().menuExists(newName)) {
            sender.sendMessage(Settings.getMenuAlreadyExistsMessage());
            return;
        }
        oldMenu.setName(newName);
        this.plugin.getMenuConfig().saveMenu(oldMenu);
        this.plugin.getMenuConfig().deleteMenu(oldName);
        sender.sendMessage(Settings.getMenuRenamedMessage());
    }

    private void handleSetHead(CommandSender sender, String[] args) {
        int slot;
        if (!sender.hasPermission("rxmenu.edit")) {
            sender.sendMessage(Settings.getNoPermissionMessage());
            return;
        }
        if (args.length < 4) {
            sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.RED) + "Usage: /rxmenu sethead <menu> <slot> <type> [value]");
            sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.GRAY) + "Types: PLAYER, TEXTURE");
            sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.GRAY) + "Example: /rxmenu sethead shop 0 PLAYER Notch");
            sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.GRAY) + "Example: /rxmenu sethead shop 0 TEXTURE eyJ0ZXh0dXJlcyI6ey...");
            return;
        }
        Menu menu = this.plugin.getMenuConfig().getMenu(args[1]);
        if (menu == null) {
            sender.sendMessage(Settings.getMenuNotFoundMessage());
            return;
        }
        try {
            slot = Integer.parseInt(args[2]);
            if (slot < 0 || slot >= menu.getSize()) {
                sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.RED) + "Invalid slot number!");
                return;
            }
        }
        catch (NumberFormatException e) {
            sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.RED) + "Slot must be a number!");
            return;
        }
        MenuItem item = menu.getItem(slot);
        if (item == null) {
            item = new MenuItem(Material.PLAYER_HEAD, "&fPlayer Head");
            menu.setItem(slot, item);
        } else if (item.getMaterial() != Material.PLAYER_HEAD) {
            item.setMaterial(Material.PLAYER_HEAD);
        }
        String type = args[3].toUpperCase();
        if (!Arrays.asList("PLAYER", "TEXTURE").contains(type)) {
            sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.RED) + "Invalid head type! Must be: PLAYER or TEXTURE");
            return;
        }
        if (type.equals("PLAYER")) {
            if (args.length < 5) {
                sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.RED) + "Please specify a player name!");
                return;
            }
            String playerName = args[4];
            item.setHeadTexture("player:" + playerName);
            sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.GREEN) + "Set head to player: " + playerName);
        } else {
            if (args.length < 5) {
                sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.RED) + "Please specify a texture value!");
                return;
            }
            String texture = args[4];
            item.setHeadTexture(texture);
            sender.sendMessage(Settings.getPrefix() + String.valueOf(ChatColor.GREEN) + "Set custom head texture!");
        }
        this.plugin.getMenuConfig().saveMenu(menu);
        menu.updateInventory();
    }

    private void sendHelp(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GRAY) + "=== " + String.valueOf(ChatColor.YELLOW) + "RxMenu Commands" + String.valueOf(ChatColor.GRAY) + " ===");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rxmenu open <name> " + String.valueOf(ChatColor.GRAY) + "- Open a menu");
        if (sender.hasPermission("rxmenu.create")) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rxmenu create <name> <size> [title] " + String.valueOf(ChatColor.GRAY) + "- Create a new menu");
        }
        if (sender.hasPermission("rxmenu.edit")) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rxmenu edit <name> " + String.valueOf(ChatColor.GRAY) + "- Edit an existing menu");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rxmenu setaction <menu> <slot> <type> <action> " + String.valueOf(ChatColor.GRAY) + "- Add action to item");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rxmenu clearaction <menu> <slot> " + String.valueOf(ChatColor.GRAY) + "- Remove all actions from item");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rxmenu setname <menu> <slot> <name> " + String.valueOf(ChatColor.GRAY) + "- Change item name");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rxmenu setdesc <menu> <slot> <line> " + String.valueOf(ChatColor.GRAY) + "- Change description line by line");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rxmenu settitle <menu> <title> " + String.valueOf(ChatColor.GRAY) + "- Change menu title");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rxmenu sethead <menu> <slot> <type> [value] " + String.valueOf(ChatColor.GRAY) + "- Set player head or texture");
        }
        if (sender.hasPermission("rxmenu.delete")) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rxmenu delete <name> " + String.valueOf(ChatColor.GRAY) + "- Delete a menu");
        }
        if (sender.hasPermission("rxmenu.list")) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rxmenu list " + String.valueOf(ChatColor.GRAY) + "- List all menus");
        }
        if (sender.hasPermission("rxmenu.reload")) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rxmenu reload " + String.valueOf(ChatColor.GRAY) + "- Reload configuration");
        }
        if (sender.hasPermission("rxmenu.admin")) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rxmenu info <name> " + String.valueOf(ChatColor.GRAY) + "- Show menu information");
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "/rxmenu rename <old> <new> " + String.valueOf(ChatColor.GRAY) + "- Rename a menu");
        }
    }
}

