/*
 * Decompiled with CFR 0.152.
 */
package org.notritik.rxmenu.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;
import org.notritik.rxmenu.RxMenu;
import org.notritik.rxmenu.models.Menu;

public class RxMenuTabCompleter
implements TabCompleter {
    private final RxMenu plugin;
    private static final String[] COMMANDS = new String[]{"reload", "open", "create", "edit", "delete", "setaction", "clearaction", "setname", "setdesc", "settitle", "list", "info", "rename", "sethead"};
    private static final String[] ACTION_TYPES = new String[]{"COMMAND", "CONSOLE", "MESSAGE"};
    private static final String[] HEAD_TYPES = new String[]{"PLAYER", "TEXTURE"};
    private static final String[] SIZES = new String[]{"9", "18", "27", "36", "45", "54"};
    private static final String[] TITLE_SUGGESTIONS = new String[]{"&6Shop Menu", "&bWarp Menu", "&eKit Menu", "&cRank Menu", "&aCrate Menu", "&dVIP Menu"};

    public RxMenuTabCompleter(RxMenu plugin) {
        this.plugin = plugin;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            ArrayList<String> commands = new ArrayList<String>();
            if (sender.hasPermission("rxmenu.admin") || sender.hasPermission("rxmenu.edit")) {
                if (sender.hasPermission("rxmenu.reload")) {
                    commands.add("reload");
                }
                commands.add("open");
                if (sender.hasPermission("rxmenu.create")) {
                    commands.add("create");
                }
                if (sender.hasPermission("rxmenu.edit")) {
                    commands.addAll(Arrays.asList("edit", "setaction", "clearaction", "setname", "setdesc", "settitle", "sethead"));
                }
                if (sender.hasPermission("rxmenu.delete")) {
                    commands.add("delete");
                }
                if (sender.hasPermission("rxmenu.list")) {
                    commands.add("list");
                }
                if (sender.hasPermission("rxmenu.admin")) {
                    commands.addAll(Arrays.asList("info", "rename"));
                }
            } else if (sender.hasPermission("rxmenu.open")) {
                commands.add("open");
            }
            StringUtil.copyPartialMatches((String)args[0], commands, completions);
        } else if (args.length == 2) {
            switch (args[0].toLowerCase()) {
                case "open": {
                    if (!sender.hasPermission("rxmenu.open") || this.plugin.getMenuConfig().getMenus().isEmpty()) break;
                    ArrayList<String> menuNames = new ArrayList<String>(this.plugin.getMenuConfig().getMenus().keySet());
                    StringUtil.copyPartialMatches((String)args[1], menuNames, completions);
                    break;
                }
                case "setdesc": 
                case "edit": 
                case "delete": 
                case "info": 
                case "setaction": 
                case "clearaction": 
                case "setname": 
                case "settitle": 
                case "rename": 
                case "sethead": {
                    if (!sender.hasPermission("rxmenu.admin") && !sender.hasPermission("rxmenu.edit") || this.plugin.getMenuConfig().getMenus().isEmpty()) break;
                    ArrayList<String> menuNames = new ArrayList<String>(this.plugin.getMenuConfig().getMenus().keySet());
                    StringUtil.copyPartialMatches((String)args[1], menuNames, completions);
                    break;
                }
                case "create": {
                    if (!sender.hasPermission("rxmenu.create")) break;
                    List<String> suggestions = Arrays.asList("shop", "warps", "kits", "ranks", "crates", "vip");
                    StringUtil.copyPartialMatches((String)args[1], suggestions, completions);
                }
            }
        } else if (args.length == 3) {
            if (!sender.hasPermission("rxmenu.admin") && !sender.hasPermission("rxmenu.edit")) {
                return completions;
            }
            switch (args[0].toLowerCase()) {
                case "setdesc": 
                case "setaction": 
                case "clearaction": 
                case "setname": 
                case "sethead": {
                    Menu menu = this.plugin.getMenuConfig().getMenu(args[1]);
                    if (menu == null) break;
                    ArrayList<String> slots = new ArrayList<String>();
                    for (int i = 0; i < menu.getSize(); ++i) {
                        slots.add(String.valueOf(i));
                    }
                    StringUtil.copyPartialMatches((String)args[2], slots, completions);
                    break;
                }
                case "create": {
                    if (!sender.hasPermission("rxmenu.create")) break;
                    StringUtil.copyPartialMatches((String)args[2], Arrays.asList(SIZES), completions);
                }
            }
        } else if (args.length == 4) {
            if (!sender.hasPermission("rxmenu.admin") && !sender.hasPermission("rxmenu.edit")) {
                return completions;
            }
            if (args[0].equalsIgnoreCase("setdesc")) {
                ArrayList<String> lines = new ArrayList<String>();
                for (int i = 1; i <= 10; ++i) {
                    lines.add(String.valueOf(i));
                }
                StringUtil.copyPartialMatches((String)args[3], lines, completions);
            } else if (args[0].equalsIgnoreCase("setitem")) {
                List materials = Arrays.stream(Material.values()).filter(mat -> !mat.name().contains("LEGACY")).map(Enum::name).collect(Collectors.toList());
                StringUtil.copyPartialMatches((String)args[3], materials, completions);
            } else if (args[0].equalsIgnoreCase("setaction")) {
                StringUtil.copyPartialMatches((String)args[3], Arrays.asList(ACTION_TYPES), completions);
            } else if (args[0].equalsIgnoreCase("sethead")) {
                StringUtil.copyPartialMatches((String)args[3], Arrays.asList(HEAD_TYPES), completions);
            } else if (args[0].equalsIgnoreCase("create") && sender.hasPermission("rxmenu.create")) {
                StringUtil.copyPartialMatches((String)args[3], Arrays.asList(TITLE_SUGGESTIONS), completions);
            }
        } else if (args.length == 5) {
            if (!sender.hasPermission("rxmenu.admin") && !sender.hasPermission("rxmenu.edit")) {
                return completions;
            }
            if (args[0].equalsIgnoreCase("setdesc")) {
                List<String> suggestions = Arrays.asList("Click to buy!", "Cost: 100 coins", "Special offer!", "Limited time only!", "Right-click for more", "VIP only item");
                StringUtil.copyPartialMatches((String)args[4], suggestions, completions);
            } else if (args[0].equalsIgnoreCase("setaction")) {
                switch (args[3].toLowerCase()) {
                    case "message": {
                        List<String> suggestions = Arrays.asList("Thanks for clicking!", "Cost: 100 coins", "Click to open!", "Teleporting to spawn...", "VIP features activated!");
                        StringUtil.copyPartialMatches((String)args[4], suggestions, completions);
                        break;
                    }
                    case "command": {
                        List<String> suggestions = Arrays.asList("warp shop", "balance", "spawn", "home", "kit vip");
                        StringUtil.copyPartialMatches((String)args[4], suggestions, completions);
                        break;
                    }
                    case "console": {
                        List<String> suggestions = Arrays.asList("give %player% diamond", "eco give %player% 100", "broadcast %player% is awesome!", "effect give %player% speed 30 2");
                        StringUtil.copyPartialMatches((String)args[4], suggestions, completions);
                        break;
                    }
                    case "broadcast": {
                        List<String> suggestions = Arrays.asList("%player% just opened a crate!", "%player% found a rare item!", "%player% is on a winning streak!", "%player% activated VIP mode!");
                        StringUtil.copyPartialMatches((String)args[4], suggestions, completions);
                        break;
                    }
                    case "open": {
                        if (this.plugin.getMenuConfig().getMenus().isEmpty()) break;
                        ArrayList<String> menuNames = new ArrayList<String>(this.plugin.getMenuConfig().getMenus().keySet());
                        StringUtil.copyPartialMatches((String)args[4], menuNames, completions);
                    }
                }
            } else if (args[0].equalsIgnoreCase("sethead") && args[3].equalsIgnoreCase("PLAYER")) {
                List playerNames = Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
                StringUtil.copyPartialMatches((String)args[4], playerNames, completions);
            }
        }
        Collections.sort(completions);
        return completions;
    }
}

