/*
 * Decompiled with CFR 0.152.
 */
package org.notritik.rxmenu.config;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.notritik.rxmenu.RxMenu;
import org.notritik.rxmenu.models.Menu;

public class MenuConfig {
    private final RxMenu plugin;
    private final Map<String, Menu> menus;
    private final File menusFolder;

    public MenuConfig(RxMenu plugin) {
        this.plugin = plugin;
        this.menus = new HashMap<String, Menu>();
        this.menusFolder = new File(plugin.getDataFolder(), "menus");
        this.loadMenus();
    }

    public void saveMenus() {
        for (Menu menu : this.menus.values()) {
            this.saveMenu(menu);
        }
    }

    public void saveMenu(Menu menu) {
        String menuName = menu.getInternalName().toLowerCase();
        this.menus.put(menuName, menu);
        this.plugin.getLogger().info("Saving menu: " + menuName);
        if (!this.menusFolder.exists()) {
            this.menusFolder.mkdirs();
        }
        File menuFile = new File(this.menusFolder, menuName + ".yml");
        YamlConfiguration menuConfig = new YamlConfiguration();
        menu.saveToConfig(menuConfig);
        try {
            menuConfig.save(menuFile);
            this.plugin.getLogger().info("Menu saved successfully: " + menuName);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Failed to save menu " + menuName + ": " + e.getMessage());
        }
    }

    private void createDefaultMenu() {
        File defaultMenu = new File(this.plugin.getDataFolder(), "example.yml");
        if (!defaultMenu.exists()) {
            YamlConfiguration config = new YamlConfiguration();
            config.set("name", (Object)"example");
            config.set("menu_title", (Object)"&6Example Menu");
            config.set("size", (Object)27);
            ConfigurationSection items = config.createSection("items");
            ConfigurationSection closeItem = items.createSection("close_button");
            closeItem.set("material", (Object)"BARRIER");
            closeItem.set("name", (Object)"&cClose Menu");
            closeItem.set("slots", (Object)"26");
            closeItem.set("left_click_commands", List.of("[close]"));
            ConfigurationSection infoItem = items.createSection("info_button");
            infoItem.set("material", (Object)"BOOK");
            infoItem.set("name", (Object)"&aInformation");
            infoItem.set("slots", (Object)"13");
            infoItem.set("lore", List.of("&7This is an example menu", "&7You can customize it in", "&7plugins/RxMenu/menus/example.yml"));
            infoItem.set("left_click_commands", List.of("[message] &aThis is an example message!", "[message] &7You can add multiple actions"));
            ConfigurationSection gamemodeSurvivalItem = items.createSection("gamemode_survival");
            gamemodeSurvivalItem.set("material", (Object)"GRASS_BLOCK");
            gamemodeSurvivalItem.set("name", (Object)"&eSurvival Mode");
            gamemodeSurvivalItem.set("slots", (Object)"10");
            gamemodeSurvivalItem.set("left_click_commands", List.of("[player] /gamemode survival"));
            ConfigurationSection gamemodeCreativeItem = items.createSection("gamemode_creative");
            gamemodeCreativeItem.set("material", (Object)"DIAMOND_BLOCK");
            gamemodeCreativeItem.set("name", (Object)"&bCreative Mode");
            gamemodeCreativeItem.set("slots", (Object)"16");
            gamemodeCreativeItem.set("left_click_commands", List.of("[player] /gamemode creative"));
            try {
                config.save(defaultMenu);
                this.plugin.getLogger().info("Created example menu configuration!");
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("Failed to create example menu: " + e.getMessage());
            }
        }
    }

    public void loadMenus() {
        if (!this.menusFolder.exists()) {
            this.menusFolder.mkdirs();
        }
        this.menus.clear();
        this.plugin.getLogger().info("Loading menus from 'menus' folder...");
        File[] menuFiles = this.menusFolder.listFiles((dir, name) -> name.endsWith(".yml"));
        if (menuFiles != null) {
            for (File menuFile : menuFiles) {
                try {
                    YamlConfiguration menuConfig = YamlConfiguration.loadConfiguration((File)menuFile);
                    Menu menu = Menu.fromConfig(menuConfig);
                    this.menus.put(menu.getInternalName().toLowerCase(), menu);
                    this.plugin.getLogger().info("Loaded menu: " + menu.getInternalName());
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Failed to load menu from file " + menuFile.getName() + ": " + e.getMessage());
                }
            }
        }
        this.plugin.getLogger().info("Loaded " + this.menus.size() + " menus from 'menus' folder");
    }

    public Menu getMenu(String name) {
        this.plugin.getLogger().info("Getting menu: " + name);
        Menu menu = this.menus.get(name.toLowerCase());
        if (menu == null) {
            this.plugin.getLogger().warning("Menu not found: " + name);
        }
        return menu;
    }

    public void createMenu(String name, Menu menu) {
        this.saveMenu(menu);
    }

    public void deleteMenu(String name) {
        name = name.toLowerCase();
        this.menus.remove(name);
        File menuFile = new File(this.menusFolder, name + ".yml");
        if (menuFile.exists()) {
            if (menuFile.delete()) {
                this.plugin.getLogger().info("Deleted menu file: " + menuFile.getName());
            } else {
                this.plugin.getLogger().warning("Failed to delete menu file: " + menuFile.getName());
            }
        }
    }

    public boolean menuExists(String name) {
        return this.menus.containsKey(name.toLowerCase());
    }

    public Map<String, Menu> getMenus() {
        return this.menus;
    }

    public void reloadMenu(String name) {
        File menuFile = new File(this.menusFolder, (name = name.toLowerCase()) + ".yml");
        if (menuFile.exists()) {
            try {
                YamlConfiguration menuConfig = YamlConfiguration.loadConfiguration((File)menuFile);
                Menu menu = Menu.fromConfig(menuConfig);
                this.menus.put(name, menu);
                this.plugin.registerMenuCommands();
                this.plugin.getLogger().info("Reloaded menu: " + name);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to reload menu " + name + ": " + e.getMessage());
            }
        } else {
            this.plugin.getLogger().warning("Menu file not found for: " + name);
        }
    }

    public void reloadAllMenus() {
        this.loadMenus();
    }

    public String getMenuTitle(String name) {
        Menu menu = this.getMenu(name);
        return menu != null ? menu.getTitle() : null;
    }

    public int getMenuSize(String name) {
        Menu menu = this.getMenu(name);
        return menu != null ? menu.getSize() : -1;
    }
}

