/*
 * Decompiled with CFR 0.152.
 */
package org.notritik.rxmenu.listeners;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.ItemStack;
import org.notritik.rxmenu.RxMenu;
import org.notritik.rxmenu.models.Menu;
import org.notritik.rxmenu.models.MenuAction;
import org.notritik.rxmenu.models.MenuItem;
import org.notritik.rxmenu.utils.Settings;

public class MenuListener
implements Listener {
    private final RxMenu plugin;

    public MenuListener(RxMenu plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        MenuItem item;
        int slot;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        Menu menu = this.findMenuByTitle(title);
        if (menu == null) {
            return;
        }
        if (player.hasPermission("rxmenu.edit") && this.isEditingMenu(player)) {
            this.handleEditMode(event, menu, player);
            return;
        }
        event.setCancelled(true);
        if (event.getClickedInventory() == event.getView().getTopInventory() && (slot = event.getSlot()) >= 0 && slot < menu.getSize() && (item = menu.getItem(slot)) != null && item.getActions() != null && !item.getActions().isEmpty()) {
            player.closeInventory();
            for (MenuAction action : item.getActions()) {
                if (action == null) continue;
                action.execute(player);
            }
        }
    }

    @EventHandler
    public void onInventoryDrag(InventoryDragEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        String title = event.getView().getTitle();
        Menu menu = this.findMenuByTitle(title);
        if (menu == null) {
            return;
        }
        if (player.hasPermission("rxmenu.edit") && this.isEditingMenu(player)) {
            boolean affectsMenu = event.getRawSlots().stream().anyMatch(slot -> slot < menu.getSize());
            if (affectsMenu) {
                event.getRawSlots().forEach(slot -> {
                    ItemStack draggedItem;
                    if (slot < menu.getSize() && (draggedItem = (ItemStack)event.getNewItems().get(slot)) != null) {
                        MenuItem menuItem = new MenuItem(draggedItem.clone());
                        menu.setItem((int)slot, menuItem);
                    }
                });
                this.plugin.getMenuConfig().saveMenu(menu);
            }
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        String title = event.getView().getTitle();
        Menu menu = this.findMenuByTitle(title);
        if (menu != null && this.isEditingMenu(player)) {
            this.plugin.getMenuConfig().saveMenu(menu);
            player.sendMessage(Settings.getMenuSavedMessage());
            this.setEditingMenu(player, null);
        }
    }

    private Menu findMenuByTitle(String title) {
        return this.plugin.getMenuConfig().getMenus().values().stream().filter(menu -> ChatColor.translateAlternateColorCodes((char)'&', (String)menu.getTitle()).equals(title)).findFirst().orElse(null);
    }

    private void handleEditMode(InventoryClickEvent event, Menu menu, Player player) {
        int slot = event.getRawSlot();
        ItemStack clickedItem = event.getCurrentItem();
        ItemStack cursorItem = event.getCursor();
        if (event.getClickedInventory() == null) {
            event.setCancelled(true);
            return;
        }
        if (event.getClickedInventory() == event.getView().getBottomInventory()) {
            return;
        }
        if (event.getClickedInventory() == event.getView().getTopInventory()) {
            if (event.isShiftClick()) {
                event.setCancelled(true);
                return;
            }
            if (clickedItem != null && clickedItem.getType() != Material.AIR && (cursorItem == null || cursorItem.getType() == Material.AIR)) {
                MenuItem menuItem = menu.getItem(slot);
                if (menuItem != null) {
                    menu.removeItem(slot);
                    this.plugin.getMenuConfig().saveMenu(menu);
                }
                return;
            }
            if (cursorItem != null && cursorItem.getType() != Material.AIR) {
                MenuItem menuItem = new MenuItem(cursorItem.clone());
                MenuItem existingItem = menu.getItem(slot);
                if (existingItem != null) {
                    menuItem.setActions((List<MenuAction>)(existingItem.getActions() != null ? new ArrayList<MenuAction>(existingItem.getActions()) : new ArrayList()));
                }
                menu.setItem(slot, menuItem);
                this.plugin.getMenuConfig().saveMenu(menu);
                return;
            }
        }
    }

    private boolean isEditingMenu(Player player) {
        return this.plugin.getEditingPlayers().containsKey(player.getUniqueId());
    }

    private void setEditingMenu(Player player, Menu menu) {
        if (menu == null) {
            this.plugin.getEditingPlayers().remove(player.getUniqueId());
        } else {
            this.plugin.getEditingPlayers().put(player.getUniqueId(), menu.getName());
        }
    }
}

