/*
 * Decompiled with CFR 0.152.
 */
package org.notritik.rxmenu.managers;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.notritik.rxmenu.RxMenu;
import org.notritik.rxmenu.models.Menu;
import org.notritik.rxmenu.models.MenuItem;

public class MenuManager {
    private final RxMenu plugin;
    private final Map<String, Menu> menus;
    private final Set<UUID> editingPlayers;
    private final Map<UUID, String> editingMenus;
    private final File menusFolder;

    public MenuManager(RxMenu plugin) {
        this.plugin = plugin;
        this.menus = new HashMap<String, Menu>();
        this.editingPlayers = new HashSet<UUID>();
        this.editingMenus = new HashMap<UUID, String>();
        this.menusFolder = new File(plugin.getDataFolder(), "menus");
        if (!this.menusFolder.exists()) {
            this.menusFolder.mkdirs();
        }
        this.loadMenus();
    }

    public void loadMenus() {
        this.menus.clear();
        File[] files = this.menusFolder.listFiles((dir, name) -> name.endsWith(".yml"));
        if (files != null) {
            for (File file : files) {
                try {
                    YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
                    Menu menu = Menu.fromConfig(config);
                    if (menu == null) continue;
                    this.menus.put(menu.getName(), menu);
                    this.plugin.getLogger().info("Loaded menu: " + menu.getName());
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Failed to load menu from " + file.getName() + ": " + e.getMessage());
                }
            }
        }
    }

    public void saveMenu(Menu menu) {
        File menuFile = new File(this.menusFolder, menu.getName() + ".yml");
        YamlConfiguration config = new YamlConfiguration();
        menu.saveToConfig(config);
        try {
            config.save(menuFile);
            this.plugin.getLogger().info("Saved menu: " + menu.getName());
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to save menu " + menu.getName() + ": " + e.getMessage());
        }
    }

    public void deleteMenu(String name) {
        this.menus.remove(name);
        File menuFile = new File(this.menusFolder, name + ".yml");
        if (menuFile.exists()) {
            menuFile.delete();
        }
    }

    public Menu createMenu(String name, String title, int size) {
        if (this.menus.containsKey(name)) {
            return null;
        }
        Menu menu = new Menu(name, title, size);
        this.menus.put(name, menu);
        this.saveMenu(menu);
        return menu;
    }

    public boolean renameMenu(String oldName, String newName) {
        if (!this.menus.containsKey(oldName) || this.menus.containsKey(newName)) {
            return false;
        }
        Menu menu = this.menus.get(oldName);
        Menu newMenu = new Menu(newName, menu.getTitle(), menu.getSize());
        for (Map.Entry<Integer, MenuItem> entry : menu.getItems().entrySet()) {
            newMenu.setItem(entry.getKey(), entry.getValue());
        }
        this.menus.put(newName, newMenu);
        this.saveMenu(newMenu);
        this.deleteMenu(oldName);
        return true;
    }

    public Menu getMenu(String name) {
        return this.menus.get(name);
    }

    public Set<String> getMenuNames() {
        return this.menus.keySet();
    }

    public boolean isEditing(Player player) {
        return this.editingPlayers.contains(player.getUniqueId());
    }

    public void setEditing(Player player, String menuName) {
        this.editingPlayers.add(player.getUniqueId());
        this.editingMenus.put(player.getUniqueId(), menuName);
    }

    public void stopEditing(Player player) {
        this.editingPlayers.remove(player.getUniqueId());
        this.editingMenus.remove(player.getUniqueId());
    }

    public String getEditingMenu(Player player) {
        return this.editingMenus.get(player.getUniqueId());
    }

    public void saveAllMenus() {
        for (Menu menu : this.menus.values()) {
            this.saveMenu(menu);
        }
    }

    public void reloadMenuFromFile(String menuName) {
        YamlConfiguration config;
        Menu menu;
        File menuFile = new File(this.menusFolder, menuName + ".yml");
        if (menuFile.exists() && (menu = Menu.fromConfig(config = YamlConfiguration.loadConfiguration((File)menuFile))) != null) {
            this.menus.put(menuName, menu);
        }
    }

    public void reloadAllMenus() {
        this.loadMenus();
    }
}

