/*
 * Decompiled with CFR 0.152.
 */
package org.notritik.rxmenu.models;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.meta.SkullMeta;
import org.notritik.rxmenu.RxMenu;
import org.notritik.rxmenu.models.MenuAction;
import org.notritik.rxmenu.models.MenuItem;

public class Menu {
    private static final Pattern HEX_PATTERN = Pattern.compile("&#([A-Fa-f0-9]{6})");
    private String name;
    private String displayName;
    private String title;
    private int size;
    private Map<Integer, MenuItem> items;
    private transient Inventory inventory;
    private UUID uuid;
    private String openCommand;
    private List<String> commandAliases;
    private String commandPermission;
    private String commandPermissionMessage;
    private String commandDescription;

    public Menu(String name, String title, int size) {
        this.displayName = name;
        this.name = name.toLowerCase();
        this.title = Menu.translateHexColorCodes(ChatColor.translateAlternateColorCodes((char)'&', (String)title));
        this.size = size;
        this.items = new HashMap<Integer, MenuItem>();
        this.uuid = UUID.randomUUID();
        this.openCommand = this.displayName;
        this.commandAliases = new ArrayList<String>();
        this.commandPermission = "";
        this.commandPermissionMessage = "";
        this.commandDescription = "Opens the " + this.title + " menu";
    }

    private static String translateHexColorCodes(String message) {
        if (message == null) {
            return "";
        }
        Matcher matcher = HEX_PATTERN.matcher(message);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String hexColor = matcher.group(1);
            matcher.appendReplacement(buffer, ChatColor.valueOf((String)("#" + hexColor)).toString());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private List<String> translateHexColorCodes(List<String> lines) {
        return lines.stream().map(Menu::translateHexColorCodes).collect(Collectors.toList());
    }

    public static Menu fromConfig(YamlConfiguration config) {
        String name = config.getString("name", "menu");
        String originalName = config.getString("display_name", name);
        String title = config.getString("title", config.getString("menu_title", "&8" + originalName));
        int size = config.getInt("size", 27);
        Menu menu = new Menu(name, title, size);
        menu.displayName = originalName;
        String openCommand = config.getString("open_command", name);
        menu.setOpenCommand(openCommand);
        ConfigurationSection itemsSection = config.getConfigurationSection("items");
        if (itemsSection != null) {
            for (String key : itemsSection.getKeys(false)) {
                List rightClickCommands;
                List commands;
                List<String> lore;
                Material material;
                String materialStr;
                ConfigurationSection itemSection = itemsSection.getConfigurationSection(key);
                if (itemSection == null || (materialStr = itemSection.getString("material")) == null) continue;
                String headTexture = null;
                if (materialStr.startsWith("basehead-")) {
                    material = Material.PLAYER_HEAD;
                    headTexture = materialStr.substring("basehead-".length());
                } else {
                    try {
                        material = Material.valueOf((String)materialStr.toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        Bukkit.getLogger().warning("Invalid material in menu " + name + ": " + materialStr);
                        continue;
                    }
                }
                String displayName = itemSection.getString("display_name", itemSection.getString("name", key));
                MenuItem item = new MenuItem(material, Menu.translateHexColorCodes(displayName.replace('&', '\u00a7')));
                if (headTexture != null) {
                    item.setHeadTexture(headTexture);
                }
                if (!(lore = itemSection.getStringList("lore")).isEmpty()) {
                    lore = lore.stream().map(line -> Menu.translateHexColorCodes(line.replace('&', '\u00a7'))).collect(Collectors.toList());
                    item.setLore(lore);
                }
                if ((commands = itemSection.getStringList("left_click_commands")) != null && !commands.isEmpty()) {
                    for (Object command : commands) {
                        item.addAction(Menu.convertDeluxeAction((String)command));
                    }
                }
                if ((rightClickCommands = itemSection.getStringList("right_click_commands")) != null && !rightClickCommands.isEmpty()) {
                    Object command;
                    command = rightClickCommands.iterator();
                    while (command.hasNext()) {
                        String command2 = (String)command.next();
                        item.addAction(Menu.convertDeluxeAction(command2));
                    }
                }
                if (itemSection.contains("slots")) {
                    String slotsStr = itemSection.getString("slots");
                    if (slotsStr == null) continue;
                    for (int slot : Menu.parseSlots(slotsStr)) {
                        menu.setItem(slot, item);
                    }
                    continue;
                }
                if (!itemSection.contains("slot")) continue;
                int slot = itemSection.getInt("slot");
                menu.setItem(slot, item);
            }
        }
        return menu;
    }

    public void saveToConfig(YamlConfiguration config) {
        config.set("name", (Object)this.name);
        config.set("display_name", (Object)this.displayName);
        config.set("title", (Object)this.title);
        config.set("size", (Object)this.size);
        config.set("open_command", (Object)this.displayName);
        config.set("register_command", (Object)true);
        ConfigurationSection itemsSection = config.createSection("items");
        for (Map.Entry<Integer, MenuItem> entry : this.items.entrySet()) {
            MenuItem item = entry.getValue();
            String itemKey = "'item_" + String.valueOf(entry.getKey()) + "'";
            ConfigurationSection itemSection = itemsSection.createSection(itemKey);
            if (item.getMaterial() == Material.PLAYER_HEAD && item.getHeadTexture() != null) {
                itemSection.set("material", (Object)("basehead-" + item.getHeadTexture()));
            } else {
                itemSection.set("material", (Object)item.getMaterial().toString());
            }
            itemSection.set("display_name", (Object)item.getName().replace('\u00a7', '&'));
            itemSection.set("slot", (Object)entry.getKey());
            if (!item.getLore().isEmpty()) {
                itemSection.set("lore", item.getLore().stream().map(line -> line.replace('\u00a7', '&')).collect(Collectors.toList()));
            }
            if (item.getActions().isEmpty()) continue;
            ArrayList<Object> commands = new ArrayList<Object>();
            for (MenuAction action : item.getActions()) {
                commands.add(switch (action.getType()) {
                    case "message" -> "[message]" + action.getData();
                    case "command" -> "[player]" + action.getData();
                    case "console" -> "[console]" + action.getData();
                    case "broadcast" -> "[broadcast]" + action.getData();
                    case "close" -> "[close]";
                    case "open" -> "[open]" + action.getData();
                    default -> action.getData();
                });
            }
            itemSection.set("left_click_commands", commands);
        }
    }

    private String formatSlots(List<Integer> slots) {
        int start;
        if (slots.isEmpty()) {
            return "";
        }
        if (slots.size() == 1) {
            return String.valueOf(slots.get(0));
        }
        slots.sort(Integer::compareTo);
        StringBuilder result = new StringBuilder();
        int prev = start = slots.get(0).intValue();
        for (int i = 1; i < slots.size(); ++i) {
            int current = slots.get(i);
            if (current != prev + 1) {
                if (start == prev) {
                    result.append(start).append(",");
                } else {
                    result.append(start).append("-").append(prev).append(",");
                }
                start = current;
            }
            prev = current;
        }
        if (start == prev) {
            result.append(start);
        } else {
            result.append(start).append("-").append(prev);
        }
        return result.toString();
    }

    private static List<Integer> parseSlots(String slotsStr) {
        String[] parts;
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (String part : parts = slotsStr.split(",")) {
            if ((part = part.trim()).contains("-")) {
                String[] range = part.split("-");
                if (range.length != 2) continue;
                try {
                    int start = Integer.parseInt(range[0].trim());
                    int end = Integer.parseInt(range[1].trim());
                    for (int i = start; i <= end; ++i) {
                        slots.add(i);
                    }
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
            }
            try {
                slots.add(Integer.parseInt(part));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return slots;
    }

    public String getName() {
        return this.displayName;
    }

    public String getInternalName() {
        return this.name;
    }

    public void setName(String newName) {
        this.displayName = newName;
        this.name = newName.toLowerCase();
        this.openCommand = this.displayName;
        this.commandPermission = "";
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title.replace('&', '\u00a7');
        if (this.inventory != null) {
            Inventory newInventory = Bukkit.createInventory(null, (int)this.size, (String)this.getDisplayTitle());
            newInventory.setContents(this.inventory.getContents());
            this.inventory = newInventory;
        }
    }

    public String getDisplayTitle() {
        return this.title;
    }

    public int getSize() {
        return this.size;
    }

    public Map<Integer, MenuItem> getItems() {
        return this.items;
    }

    public MenuItem getItem(int slot) {
        return this.items.get(slot);
    }

    public void setItem(int slot, MenuItem item) {
        this.items.put(slot, item);
        if (this.inventory != null) {
            this.inventory.setItem(slot, item.toItemStack());
        }
    }

    public void removeItem(int slot) {
        this.items.remove(slot);
        if (this.inventory != null) {
            this.inventory.clear(slot);
        }
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Inventory getInventory() {
        if (this.inventory == null) {
            this.createInventory();
        }
        return this.inventory;
    }

    private void createInventory() {
        this.inventory = Bukkit.createInventory(null, (int)this.size, (String)this.getDisplayTitle());
        this.updateInventory();
    }

    public void updateInventory() {
        if (this.inventory != null) {
            this.inventory.clear();
            for (Map.Entry<Integer, MenuItem> entry : this.items.entrySet()) {
                this.inventory.setItem(entry.getKey().intValue(), entry.getValue().toItemStack());
            }
        }
    }

    public void open(Player player) {
        if (this.inventory == null) {
            this.inventory = Bukkit.createInventory(null, (int)this.size, (String)ChatColor.translateAlternateColorCodes((char)'&', (String)this.title));
            for (Map.Entry<Integer, MenuItem> entry : this.items.entrySet()) {
                this.inventory.setItem(entry.getKey().intValue(), entry.getValue().toItemStack());
            }
        }
        player.openInventory(this.inventory);
    }

    private void applyHeadTexture(SkullMeta meta, String texture) {
        try {
            Class<?> gameProfileClass = Class.forName("com.mojang.authlib.GameProfile");
            Class<?> propertyClass = Class.forName("com.mojang.authlib.properties.Property");
            Constructor<?> profileConstructor = gameProfileClass.getDeclaredConstructor(UUID.class, String.class);
            Object profile = profileConstructor.newInstance(UUID.randomUUID(), null);
            Method getPropertiesMethod = gameProfileClass.getDeclaredMethod("getProperties", new Class[0]);
            Object properties = getPropertiesMethod.invoke(profile, new Object[0]);
            Constructor<?> propertyConstructor = propertyClass.getDeclaredConstructor(String.class, String.class);
            Object property = propertyConstructor.newInstance("textures", texture);
            Method putMethod = properties.getClass().getDeclaredMethod("put", Object.class, Object.class);
            putMethod.invoke(properties, "textures", property);
            Field profileField = meta.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            profileField.set(meta, profile);
        }
        catch (Exception e) {
            Bukkit.getLogger().warning("Failed to apply head texture: " + e.getMessage());
        }
    }

    private List<String> colorize(List<String> lines) {
        return lines.stream().map(line -> ChatColor.translateAlternateColorCodes((char)'&', (String)line)).collect(Collectors.toList());
    }

    public String getOpenCommand() {
        return this.openCommand;
    }

    public void setOpenCommand(String command) {
        this.openCommand = command;
    }

    public List<String> getCommandAliases() {
        return this.commandAliases;
    }

    public void setCommandAliases(List<String> aliases) {
        this.commandAliases = aliases;
    }

    public String getCommandPermission() {
        return this.commandPermission;
    }

    public void setCommandPermission(String permission) {
        this.commandPermission = permission;
    }

    public String getCommandPermissionMessage() {
        return this.commandPermissionMessage;
    }

    public void setCommandPermissionMessage(String message) {
        this.commandPermissionMessage = message;
    }

    public String getCommandDescription() {
        return this.commandDescription;
    }

    public void setCommandDescription(String description) {
        this.commandDescription = description;
    }

    private static MenuAction convertDeluxeAction(String action) {
        if (action.startsWith("[player]")) {
            return MenuAction.command(action.substring(8).trim());
        }
        if (action.startsWith("[console]")) {
            return MenuAction.consoleCommand(action.substring(9).trim());
        }
        if (action.startsWith("[message]")) {
            return MenuAction.message(action.substring(9).trim());
        }
        if (action.startsWith("[broadcast]")) {
            return MenuAction.broadcast(action.substring(11).trim());
        }
        if (action.startsWith("[close]")) {
            return MenuAction.close();
        }
        if (action.startsWith("[openguimenu]") || action.startsWith("[open]")) {
            String menuName = action.startsWith("[openguimenu]") ? action.substring(12).trim() : action.substring(6).trim();
            return MenuAction.open(menuName);
        }
        return MenuAction.message(action);
    }

    public static boolean isRxMenuInventory(Inventory inventory) {
        if (inventory == null) {
            return false;
        }
        InventoryView view = null;
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.getOpenInventory().getTopInventory().equals((Object)inventory)) continue;
            view = player.getOpenInventory();
            break;
        }
        if (view == null) {
            return false;
        }
        String title = view.getTitle();
        if (title == null) {
            return false;
        }
        return RxMenu.getInstance().getMenuConfig().getMenus().values().stream().anyMatch(menu -> ChatColor.translateAlternateColorCodes((char)'&', (String)menu.getTitle()).equals(title));
    }
}

